// Copyright (C) 2022 Fredrik Öhrström (CC0)
#ifndef MANUFACTURERS_H
#define MANUFACTURERS_H
#define MANFCODE(a,b,c) ((a-64)*1024+(b-64)*32+(c-64))
#define LIST_OF_MANUFACTURERS \
X(AAA,MANFCODE('A','A','A'),"Aventies, Germany")\
X(AAB,MANFCODE('A','A','B'),"Milas")\
X(ABB,MANFCODE('A','B','B'),"ABB, Sweden")\
X(ABC,MANFCODE('A','B','C'),"Paya Energy")\
X(ABN,MANFCODE('A','B','N'),"ABN Braun, Germany")\
X(ABR,MANFCODE('A','B','R'),"ABB, Czech Republic")\
X(ACA,MANFCODE('A','C','A'),"Acean, France")\
X(ACB,MANFCODE('A','C','B'),"AcBel Polytech, Taiwan")\
X(ACC,MANFCODE('A','C','C'),"Accurate, Pakistan")\
X(ACE,MANFCODE('A','C','E'),"Actaris Electricity, France")\
X(ACG,MANFCODE('A','C','G'),"Actaris Gas, France")\
X(ACH,MANFCODE('A','C','H'),"Acantho, Italy")\
X(ACL,MANFCODE('A','C','L'),"Aclara Meters UK, United Kingdom")\
X(ACN,MANFCODE('A','C','N'),"ACN Advanced Communications Networks, Switzerland")\
X(ACS,MANFCODE('A','C','S'),"Tianjin Chuangshi Technology Developing, China")\
X(ACT,MANFCODE('A','C','T'),"Activis Metering, Germany")\
X(ACW,MANFCODE('A','C','W'),"Actaris Water and Heat, France")\
X(ADA,MANFCODE('A','D','A'),"Andrea Informatique, France")\
X(ADD,MANFCODE('A','D','D'),"ADD Production, Moldova")\
X(ADE,MANFCODE('A','D','E'),"Yantai Aerospace Delu Energy saving Technology, China")\
X(ADF,MANFCODE('A','D','F'),"ADFweb com, Italy")\
X(ADN,MANFCODE('A','D','N'),"Aidon, Finland")\
X(ADR,MANFCODE('A','D','R'),"Adrem Engineering, Romania")\
X(ADU,MANFCODE('A','D','U'),"Adunos, Germany")\
X(ADV,MANFCODE('A','D','V'),"Advant")\
X(ADX,MANFCODE('A','D','X'),"ADD Production, Moldova")\
X(AEA,MANFCODE('A','E','A'),"Abam Electronic Alborz, Iran")\
X(AEC,MANFCODE('A','E','C'),"Advance Electronics Company, Saudi Arabia")\
X(AEE,MANFCODE('A','E','E'),"Atlas Electronics, Serbia")\
X(AEG,MANFCODE('A','E','G'),"AEG")\
X(AEI,MANFCODE('A','E','I'),"Ajay Electrical Industries, India")\
X(AEL,MANFCODE('A','E','L'),"Kohler, Turkey")\
X(AEM,MANFCODE('A','E','M'),"S C AEM, Romania")\
X(AER,MANFCODE('A','E','R'),"Aerzener Maschinenfabrik, Germany")\
X(AES,MANFCODE('A','E','S'),"ALFANAR ELECTRICAL SYSTEM, Saudi Arabia")\
X(AFX,MANFCODE('A','F','X'),"Alflex Products, Netherlands")\
X(AGE,MANFCODE('A','G','E'),"AccessGate, Sweden")\
X(AGT,MANFCODE('A','G','T'),"Agnitio Technologies, India")\
X(AHV,MANFCODE('A','H','V'),"aventies, Germany")\
X(AHX,MANFCODE('A','H','X'),"Sepanta Electronic Tabarestan, Iran")\
X(AIC,MANFCODE('A','I','C'),"Avastu Creations, India")\
X(AIM,MANFCODE('A','I','M'),"Ningbo Aimei Meter Manufacture, China")\
X(ALC,MANFCODE('A','L','C'),"Zenner Gas, Italy")\
X(ALF,MANFCODE('A','L','F'),"Alfatech Elektromed Elektronik, Turkey")\
X(ALG,MANFCODE('A','L','G'),"Algodue Elettronica, Italy")\
X(ALH,MANFCODE('A','L','H'),"ALFANAR ELECTRICAL SYSTEM, Saudi Arabia")\
X(ALK,MANFCODE('A','L','K'),"Actislink, Poland")\
X(ALL,MANFCODE('A','L','L'),"Allied Engineering Works, India")\
X(ALP,MANFCODE('A','L','P'),"Alphion, India")\
X(ALR,MANFCODE('A','L','R'),"Algorab, Italy")\
X(ALT,MANFCODE('A','L','T'),"Amplitec, Germany")\
X(ALV,MANFCODE('A','L','V'),"Alvicom, Hungary")\
X(AMB,MANFCODE('A','M','B'),"Wurth Elektronik eiSos, Germany")\
X(AMC,MANFCODE('A','M','C'),"Arch Meter Corporation, Taiwan")\
X(AMD,MANFCODE('A','M','D'),"KEPID AMSTECH, South Korea")\
X(AME,MANFCODE('A','M','E'),"Avon Meters, India")\
X(AMG,MANFCODE('A','M','G'),"ANTE METER GROUP, China")\
X(AMH,MANFCODE('A','M','H'),"AmiHo, United Kingdom")\
X(AMI,MANFCODE('A','M','I'),"AMI Tech I, India")\
X(AML,MANFCODE('A','M','L'),"Eon Electric, India")\
X(AMP,MANFCODE('A','M','P'),"Ampy Automation Digilog")\
X(AMR,MANFCODE('A','M','R'),"Actislink, Poland")\
X(AMS,MANFCODE('A','M','S'),"Zhejiang Joy Electronic Technology, China")\
X(AMT,MANFCODE('A','M','T'),"INTEGRA METERING")\
X(AMX,MANFCODE('A','M','X'),"APATOR METRIX, Poland")\
X(ANA,MANFCODE('A','N','A'),"Anacle Systems, Singapore")\
X(AND,MANFCODE('A','N','D'),"Andis, Slovakia")\
X(ANZ,MANFCODE('A','N','Z'),"Anhui Nari Zenith Electricity Electronic")\
X(AOM,MANFCODE('A','O','M'),"Aquametro Oil Marine, Switzerland")\
X(AON,MANFCODE('A','O','N'),"ASTRON, Slovenia")\
X(APA,MANFCODE('A','P','A'),"Apator, Poland")\
X(APL,MANFCODE('A','P','L'),"APLI, Slovakia")\
X(APO,MANFCODE('A','P','O'),"APOLIS haftungsbeschraenkt, Germany")\
X(APR,MANFCODE('A','P','R'),"Apronecs, Bulgaria")\
X(APS,MANFCODE('A','P','S'),"Apsis Kontrol Sistemleri, Turkey")\
X(APT,MANFCODE('A','P','T'),"Apator, Poland")\
X(APX,MANFCODE('A','P','X'),"Amplex, Denmark")\
X(AQA,MANFCODE('A','Q','A'),"ACTAQUA, Germany")\
X(AQL,MANFCODE('A','Q','L'),"Aqualoc, South Africa")\
X(AQM,MANFCODE('A','Q','M'),"INTEGRA METERING, Switzerland")\
X(AQT,MANFCODE('A','Q','T'),"Aquatherm PPH, Poland")\
X(AQU,MANFCODE('A','Q','U'),"Aquamess, Germany")\
X(ARA,MANFCODE('A','R','A'),"Aranha, United Kingdom")\
X(ARC,MANFCODE('A','R','C'),"Arcelik, Turkey")\
X(ARD,MANFCODE('A','R','D'),"Arad Group, Israel")\
X(ARF,MANFCODE('A','R','F'),"ADEUNIS RF, France")\
X(ARG,MANFCODE('A','R','G'),"ARGO group of companies, Russian Federation")\
X(ARK,MANFCODE('A','R','K'),"Arkon Flow Systems, Czech Republic")\
X(ARM,MANFCODE('A','R','M'),"Arivus metering, Germany")\
X(ARS,MANFCODE('A','R','S'),"ADD, Bulgaria")\
X(ART,MANFCODE('A','R','T'),"Electrotecnica Arteche Smart Grid, Spain")\
X(ARW,MANFCODE('A','R','W'),"Arrow Electronics, India")\
X(ASA,MANFCODE('A','S','A'),"Asac, Italy")\
X(ASC,MANFCODE('A','S','C'),"A2A Smart City, Italy")\
X(ASD,MANFCODE('A','S','D'),"AS DAQ SYSTEMS, India")\
X(ASG,MANFCODE('A','S','G'),"Meter technology Company, Saudi Arabia")\
X(ASH,MANFCODE('A','S','H'),"Basic Electronics Company, Saudi Arabia")\
X(ASJ,MANFCODE('A','S','J'),"ACCUMET SOLUTIONS, India")\
X(ASM,MANFCODE('A','S','M'),"Adya Wifi Metering, India")\
X(ASR,MANFCODE('A','S','R'),"Erelsan Elektrik ve Elektronik, Turkey")\
X(AST,MANFCODE('A','S','T'),"ASTINCO, Canada")\
X(ATF,MANFCODE('A','T','F'),"AKTIF OTOMASYON STI, Turkey")\
X(ATI,MANFCODE('A','T','I'),"Analogics Tech, India")\
X(ATL,MANFCODE('A','T','L'),"Atlas Elektronik, Turkey")\
X(ATM,MANFCODE('A','T','M'),"Atmel SAU, Spain")\
X(ATS,MANFCODE('A','T','S'),"Atlas Sayac Sanayi, Turkey")\
X(AUR,MANFCODE('A','U','R'),"Aurum Europe, Netherlands")\
X(AUT,MANFCODE('A','U','T'),"Aiut, Poland")\
X(AUX,MANFCODE('A','U','X'),"Ningbo Sanxing Smart Electric, China")\
X(AVA,MANFCODE('A','V','A'),"Avangard JSC, Russian Federation")\
X(AXI,MANFCODE('A','X','I'),"UAB Axis Industries, Lithuania")\
X(AXS,MANFCODE('A','X','S'),"AXSEM, Switzerland")\
X(AYS,MANFCODE('A','Y','S'),"Euromet Stl, Turkey")\
X(AZE,MANFCODE('A','Z','E'),"AZEL Electronics, Turkey")\
X(BAM,MANFCODE('B','A','M'),"Bachmann, Germany")\
X(BAR,MANFCODE('B','A','R'),"Baer Industrie Elektronik, Germany")\
X(BAS,MANFCODE('B','A','S'),"BASIC INTELLIGENCE TECHNOLOGY, China")\
X(BBE,MANFCODE('B','B','E'),"Bentec Bhartia Engineers, India")\
X(BBS,MANFCODE('B','B','S'),"BBS Electronics, Singapore")\
X(BCE,MANFCODE('B','C','E'),"ShenZhen B C Electronic, China")\
X(BCR,MANFCODE('B','C','R'),"Jiangsu Bingchen Electronics, China")\
X(BEA,MANFCODE('B','E','A'),"Baer Energy Automation, Germany")\
X(BEE,MANFCODE('B','E','E'),"Bentec, India")\
X(BEF,MANFCODE('B','E','F'),"BEFEGA, Germany")\
X(BEG,MANFCODE('B','E','G'),"begcomm Communication, Sweden")\
X(BEL,MANFCODE('B','E','L'),"Belassitsa AD, Bulgaria")\
X(BEN,MANFCODE('B','E','N'),"BEENIC, Germany")\
X(BER,MANFCODE('B','E','R'),"Bernina Electronic, Switzerland")\
X(BFW,MANFCODE('B','F','W'),"BFW Buero fuer Waermemesstechnik OHG, Germany")\
X(BHG,MANFCODE('B','H','G'),"Brunata, Denmark")\
X(BJY,MANFCODE('B','J','Y'),"Beijing JOYO smart water meter, China")\
X(BKB,MANFCODE('B','K','B'),"Boendekomfort, Sweden")\
X(BKO,MANFCODE('B','K','O'),"Beko Elektronik, Turkey")\
X(BKT,MANFCODE('B','K','T'),"Bekto Precisa, Bosnia and Herzegovina")\
X(BLM,MANFCODE('B','L','M'),"BELIMO Automation, Switzerland")\
X(BLU,MANFCODE('B','L','U'),"Bluering, Italy")\
X(BME,MANFCODE('B','M','E'),"Beifeng, Germany")\
X(BMI,MANFCODE('B','M','I'),"Badger Meter, United States of America")\
X(BMP,MANFCODE('B','M','P'),"BMETERS Polska, Poland")\
X(BMT,MANFCODE('B','M','T'),"BMETERS, Italy")\
X(BNR,MANFCODE('B','N','R'),"Beijing Banner Electric, China")\
X(BOV,MANFCODE('B','O','V'),"JiaXing Bove Intelligent Technology, China")\
X(BPM,MANFCODE('B','P','M'),"Aadharshila Mobility Solutions, India")\
X(BRA,MANFCODE('B','R','A'),"Brandes, Germany")\
X(BRN,MANFCODE('B','R','N'),"Bruntab Energy, Iran")\
X(BRT,MANFCODE('B','R','T'),"BEREKET TEKNOLOJIK OELCUM SISTEMLERI BIL ELK INS ITH IHR SAN VE TIC STI, Turkey")\
X(BSC,MANFCODE('B','S','C'),"Sanaye Sanjesh Energy Behineh Sazan Toos, Iran")\
X(BSD,MANFCODE('B','S','D'),"BSED, Germany")\
X(BSE,MANFCODE('B','S','E'),"Basari Elektronik, Turkey")\
X(BSM,MANFCODE('B','S','M'),"Bluestar Electrical Meter Research Institute, China")\
X(BSP,MANFCODE('B','S','P'),"Byucksan Power, South Korea")\
X(BSS,MANFCODE('B','S','S'),"Baylan Su Sayaclari, Turkey")\
X(BST,MANFCODE('B','S','T'),"BESTAS Elektronik Optik, Turkey")\
X(BSX,MANFCODE('B','S','X'),"BS Messtechnik, Germany")\
X(BTA,MANFCODE('B','T','A'),"Buta Elektromekanik, Turkey")\
X(BTL,MANFCODE('B','T','L'),"BIT LAB")\
X(BTR,MANFCODE('B','T','R'),"RIA BTR Produktions, Germany")\
X(BTS,MANFCODE('B','T','S'),"Basari Teknolojik Sistemler, Turkey")\
X(BUR,MANFCODE('B','U','R'),"Bopp und Reuther Messtechnik, Germany")\
X(BUY,MANFCODE('B','U','Y'),"BUYI TECHNOLOGOY, China")\
X(BXC,MANFCODE('B','X','C'),"Beijing Fuxing Xiao Cheng Electronic Technology Stock Xisanhuan Beilu, China")\
X(BYD,MANFCODE('B','Y','D'),"BYD Company, China")\
X(BYL,MANFCODE('B','Y','L'),"Baylan, Turkey")\
X(BYW,MANFCODE('B','Y','W'),"Baylan Water Meters, Turkey")\
X(BZR,MANFCODE('B','Z','R'),"Gebr Bauer, Germany")\
X(CAB,MANFCODE('C','A','B'),"Cabtronix, Switzerland")\
X(CAD,MANFCODE('C','A','D'),"CADIS, Belgium")\
X(CAH,MANFCODE('C','A','H'),"MAEC GROUPE CAHORS, France")\
X(CAL,MANFCODE('C','A','L'),"Caleffi, Italy")\
X(CAR,MANFCODE('C','A','R'),"CARI Electronic, France")\
X(CAT,MANFCODE('C','A','T'),"Cubes And Tubes, Finland")\
X(CAV,MANFCODE('C','A','V'),"CaveTronic, Poland")\
X(CBI,MANFCODE('C','B','I'),"Circuit Breaker Industries, South Africa")\
X(CBS,MANFCODE('C','B','S'),"CB Svendsen, Denmark")\
X(CCS,MANFCODE('C','C','S'),"Chetas Control Systems, India")\
X(CDA,MANFCODE('C','D','A'),"Centre for Development of Advanced Computing, India")\
X(CDL,MANFCODE('C','D','L'),"Customised Data, United Kingdom")\
X(CDT,MANFCODE('C','D','T'),"CENTRE FOR DEVELOPMENT OF TELEMATICS, India")\
X(CEB,MANFCODE('C','E','B'),"Cebyc, Norway")\
X(CEG,MANFCODE('C','E','G'),"Consolinno Energy, Germany")\
X(CEL,MANFCODE('C','E','L'),"Creative Electronics, Pakistan")\
X(CEM,MANFCODE('C','E','M'),"YAVUZ METAL SANAYI VE TICARET, Turkey")\
X(CET,MANFCODE('C','E','T'),"Cetinkaya Aydinlatma, Turkey")\
X(CGC,MANFCODE('C','G','C'),"Contor Group, Romania")\
X(CGO,MANFCODE('C','G','O'),"Cavagna Group, Italy")\
X(CHC,MANFCODE('C','H','C'),"CHUN IL INSTRUMENT, South Korea")\
X(CHE,MANFCODE('C','H','E'),"Shandong Chenhui Electronic Technology, China")\
X(CHM,MANFCODE('C','H','M'),"Chung Hsin Electric and Machinery Manufacturing, Taiwan")\
X(CHS,MANFCODE('C','H','S'),"Smart Services International, Switzerland")\
X(CIR,MANFCODE('C','I','R'),"Circutor, Spain")\
X(CJS,MANFCODE('C','J','S'),"CJS Technology, United Kingdom")\
X(CKT,MANFCODE('C','K','T'),"CKT Elektrik Elektronik Sanayi ve Ticaret, Turkey")\
X(CLA,MANFCODE('C','L','A'),"3g celllabs, India")\
X(CLB,MANFCODE('C','L','B'),"CMC, Italy")\
X(CLE,MANFCODE('C','L','E'),"Shen Zhen Clou Electronics, China")\
X(CLO,MANFCODE('C','L','O'),"Clorius Raab Karcher Energi Service")\
X(CLS,MANFCODE('C','L','S'),"Celsa Messgeraete, Germany")\
X(CLT,MANFCODE('C','L','T'),"Zhuhai S E Z Calintech Electric, China")\
X(CLY,MANFCODE('C','L','Y'),"Clayster, Sweden")\
X(CMC,MANFCODE('C','M','C'),"CMC EKOCON, Slovenia")\
X(CMP,MANFCODE('C','M','P'),"CM Partner, South Korea")\
X(CMS,MANFCODE('C','M','S'),"CMS Computers")\
X(CMT,MANFCODE('C','M','T'),"CMOSTEK MICROELECTRONICS, China")\
X(CMV,MANFCODE('C','M','V'),"Comverge, United States of America")\
X(CNM,MANFCODE('C','N','M'),"COSTEL, South Korea")\
X(CNU,MANFCODE('C','N','U'),"CNU Global, South Korea")\
X(COH,MANFCODE('C','O','H'),"COHEAT Future Business Centre, United Kingdom")\
X(COM,MANFCODE('C','O','M'),"COMMON, Poland")\
X(CON,MANFCODE('C','O','N'),"Conlog")\
X(CPG,MANFCODE('C','P','G'),"CentraPlus, Germany")\
X(CPL,MANFCODE('C','P','L'),"CPL CONCORDIA Soc Coop, Italy")\
X(CPO,MANFCODE('C','P','O'),"C3PO, Spain")\
X(CPS,MANFCODE('C','P','S'),"CAPITAL POWER SYSTEMS, India")\
X(CQC,MANFCODE('C','Q','C'),"Yueqing Qicheng Electric, China")\
X(CRD,MANFCODE('C','R','D'),"CRDM DEVELOPPEMENTS, France")\
X(CRT,MANFCODE('C','R','T'),"CRDM Technology, France")\
X(CRW,MANFCODE('C','R','W'),"Xuzhou Runwu Science and Technology Development, China")\
X(CRX,MANFCODE('C','R','X'),"Corinex Communications, Canada")\
X(CRY,MANFCODE('C','R','Y'),"Crystal Power, India")\
X(CSC,MANFCODE('C','S','C'),"CHUBUSEIKI, Japan")\
X(CSL,MANFCODE('C','S','L'),"Comsel System, Finland")\
X(CSP,MANFCODE('C','S','P'),"CSP Innovazione nelle ICT, Italy")\
X(CTE,MANFCODE('C','T','E'),"COSTER T E, Italy")\
X(CTL,MANFCODE('C','T','L'),"Cyan Technology, United Kingdom")\
X(CTQ,MANFCODE('C','T','Q'),"Control Q, Netherlands")\
X(CTR,MANFCODE('C','T','R'),"Contar Electronica Industrial, Portugal")\
X(CTT,MANFCODE('C','T','T'),"DLMS User Association Conformance, Switzerland")\
X(CTX,MANFCODE('C','T','X'),"Contronix, Germany")\
X(CUC,MANFCODE('C','U','C'),"Cuculus, Germany")\
X(CUR,MANFCODE('C','U','R'),"CURRENT Group, United States of America")\
X(CWA,MANFCODE('C','W','A'),"CompWell, Sweden")\
X(CWI,MANFCODE('C','W','I'),"Cewe Instrument, Sweden")\
X(CWV,MANFCODE('C','W','V'),"CMEC Electric Import Export, China")\
X(CYE,MANFCODE('C','Y','E'),"Quanzhou Chiyoung Electronics Technology, China")\
X(CYI,MANFCODE('C','Y','I'),"QUANZHOU CHIYOUNG INSTRUMENT, China")\
X(CYN,MANFCODE('C','Y','N'),"Cynox Weinart Engineering, Germany")\
X(CZA,MANFCODE('C','Z','A'),"Contadores de Agua de Zaragoza, Spain")\
X(CZM,MANFCODE('C','Z','M'),"Cazzaniga")\
X(DAE,MANFCODE('D','A','E'),"DAE, Italy")\
X(DAF,MANFCODE('D','A','F'),"Daf Enerji Sanayi ve Ticaret, Turkey")\
X(DAN,MANFCODE('D','A','N'),"Danubia")\
X(DBE,MANFCODE('D','B','E'),"Decibels Electronics P Decibels Electronics, India")\
X(DCD,MANFCODE('D','C','D'),"Delhi Control Devices, India")\
X(DDE,MANFCODE('D','D','E'),"D D Elettronica, Italy")\
X(DDI,MANFCODE('D','D','I'),"DD Infraventures, India")\
X(DDL,MANFCODE('D','D','L'),"DONGDO LMS, South Korea")\
X(DEA,MANFCODE('D','E','A'),"Dea HT, Italy")\
X(DEC,MANFCODE('D','E','C'),"DECODE Data Communications, Serbia")\
X(DEL,MANFCODE('D','E','L'),"DELTAMESS DWWF, Germany")\
X(DEN,MANFCODE('D','E','N'),"Ducati Energia, Italy")\
X(DES,MANFCODE('D','E','S'),"Desi Alarms, Turkey")\
X(DEV,MANFCODE('D','E','V'),"Develco Products, Denmark")\
X(DFE,MANFCODE('D','F','E'),"Dongfang Electronics, China")\
X(DFS,MANFCODE('D','F','S'),"Danfoss")\
X(DGC,MANFCODE('D','G','C'),"Digicom, Italy")\
X(DGI,MANFCODE('D','G','I'),"Digi International")\
X(DGM,MANFCODE('D','G','M'),"Diehl Gas Metering, Germany")\
X(DGY,MANFCODE('D','G','Y'),"Discovergy, Germany")\
X(DHA,MANFCODE('D','H','A'),"Shanghai dahua measuring auto control instruments manufactory, China")\
X(DHQ,MANFCODE('D','H','Q'),"YIDU Smart Technology Beijing, China")\
X(DIE,MANFCODE('D','I','E'),"Dielen, Germany")\
X(DIG,MANFCODE('D','I','G'),"Digutal Request, Germany")\
X(DIL,MANFCODE('D','I','L'),"DECCAN INFRATECH LIMETED, India")\
X(DJA,MANFCODE('D','J','A'),"De Jaeger Automation, Belgium")\
X(DKY,MANFCODE('D','K','Y'),"Electric Power Research Institute of Guangdong Power Grid Corporation, China")\
X(DLX,MANFCODE('D','L','X'),"Delixi Group Instruments Meters, China")\
X(DMC,MANFCODE('D','M','C'),"DMC International, United Arab Emirates")\
X(DME,MANFCODE('D','M','E'),"DIEHL Metering, Germany")\
X(DMP,MANFCODE('D','M','P'),"DM Power, South Korea")\
X(DMS,MANFCODE('D','M','S'),"Digilog Micro Solutions, India")\
X(DNB,MANFCODE('D','N','B'),"Dana Sanjesh o Bargh Danaab, Iran")\
X(DNO,MANFCODE('D','N','O'),"DENO, Croatia")\
X(DNT,MANFCODE('D','N','T'),"Dr Neuhaus Telekommunikation, Germany")\
X(DNV,MANFCODE('D','N','V'),"DNV GL, Netherlands")\
X(DOM,MANFCODE('D','O','M'),"Domat Control System, Czech Republic")\
X(DOS,MANFCODE('D','O','S'),"Metsec Cables, Kenya")\
X(DPM,MANFCODE('D','P','M'),"DELTA PRIMA METERING SDN BHD")\
X(DPP,MANFCODE('D','P','P'),"DECCAN POWER PRODUCTS, India")\
X(DRC,MANFCODE('D','R','C'),"DURECOM, South Korea")\
X(DRT,MANFCODE('D','R','T'),"DRESSER Italia, Italy")\
X(DSE,MANFCODE('D','S','E'),"Digitech Systems and Engineering, India")\
X(DST,MANFCODE('D','S','T'),"Shenzhen Donsun Technology, China")\
X(DUA,MANFCODE('D','U','A'),"DLMS User Association, Switzerland")\
X(DVG,MANFCODE('D','V','G'),"Device, Germany")\
X(DVL,MANFCODE('D','V','L'),"devolo, Germany")\
X(DWZ,MANFCODE('D','W','Z'),"Lorenz, Germany")\
X(DZG,MANFCODE('D','Z','G'),"DZG Metering, Germany")\
X(EAA,MANFCODE('E','A','A'),"Electronic Afzar Azma, Iran")\
X(EAD,MANFCODE('E','A','D'),"EAD Energieabrechnungssysteme")\
X(EAH,MANFCODE('E','A','H'),"Endress Hauser, Germany")\
X(EAS,MANFCODE('E','A','S'),"EAS Elektronik San Tic, Turkey")\
X(EBK,MANFCODE('E','B','K'),"Biesenthal, Germany")\
X(EBV,MANFCODE('E','B','V'),"EBV Elektronik, Germany")\
X(EBZ,MANFCODE('E','B','Z'),"eBZ, Germany")\
X(ECA,MANFCODE('E','C','A'),"ECO ADAPT, France")\
X(ECC,MANFCODE('E','C','C'),"Energycare Company, Saudi Arabia")\
X(ECH,MANFCODE('E','C','H'),"Networked Energy Services Corporation, United States of America")\
X(ECL,MANFCODE('E','C','L'),"Electronics Corporation of, India")\
X(ECM,MANFCODE('E','C','M'),"Ecomess, Poland")\
X(ECO,MANFCODE('E','C','O'),"Engie BtoC Smart program, France")\
X(ECS,MANFCODE('E','C','S'),"Herholdt Controls, Italy")\
X(EDI,MANFCODE('E','D','I'),"Enel Distribuzione Via Ombrone, Italy")\
X(EDM,MANFCODE('E','D','M'),"EDMI")\
X(EEC,MANFCODE('E','E','C'),"ESCO, Poland")\
X(EEE,MANFCODE('E','E','E'),"3E, Italy")\
X(EEO,MANFCODE('E','E','O'),"Eppeltone Engineers, India")\
X(EEP,MANFCODE('E','E','P'),"ELECTRONET EQUIPMENT, India")\
X(EES,MANFCODE('E','E','S'),"Eletra Industria e Comercio de Medidores Eletricos, Brazil")\
X(EFA,MANFCODE('E','F','A'),"EFACEC Engenharia e Sistemas, Portugal")\
X(EFE,MANFCODE('E','F','E'),"Engelmann Sensor, Germany")\
X(EFI,MANFCODE('E','F','I'),"Efimatic Iberica, Spain")\
X(EFN,MANFCODE('E','F','N'),"EFEN, Germany")\
X(EFR,MANFCODE('E','F','R'),"Europaeische Funk Rundsteuerung, Germany")\
X(EFS,MANFCODE('E','F','S'),"EFSYS, France")\
X(EGA,MANFCODE('E','G','A'),"eGain International, Sweden")\
X(EGC,MANFCODE('E','G','C'),"Ekbatan Gas Control, Iran")\
X(EGD,MANFCODE('E','G','D'),"EcoGuard, Sweden")\
X(EGM,MANFCODE('E','G','M'),"Elgama Elektronika, Lithuania")\
X(EGW,MANFCODE('E','G','W'),"Enermess Energie Mess und Servicedienste, Germany")\
X(EGY,MANFCODE('E','G','Y'),"ian Smart Meter Company, Egypt")\
X(EHL,MANFCODE('E','H','L'),"Secure Meters")\
X(EIE,MANFCODE('E','I','E'),"Ei Electronics, Ireland")\
X(EIP,MANFCODE('E','I','P'),"Elmeasure, India")\
X(EIT,MANFCODE('E','I','T'),"EnergyICT, Belgium")\
X(EKA,MANFCODE('E','K','A'),"Eka Systems, United States of America")\
X(EKO,MANFCODE('E','K','O'),"EKOLIS, France")\
X(EKS,MANFCODE('E','K','S'),"DICLE KOEK ENERJI YATIRIM")\
X(EKT,MANFCODE('E','K','T'),"PA KVANT J S, Russian Federation")\
X(ELC,MANFCODE('E','L','C'),"CJSC EMIS, Russian Federation")\
X(ELD,MANFCODE('E','L','D'),"Elektromed Elektronik, Turkey")\
X(ELE,MANFCODE('E','L','E'),"Elster Electricity, United States of America")\
X(ELG,MANFCODE('E','L','G'),"Elgas, Czech Republic")\
X(ELL,MANFCODE('E','L','L'),"Energy Plus, Russian Federation")\
X(ELM,MANFCODE('E','L','M'),"Elektromed Elektronik, Turkey")\
X(ELO,MANFCODE('E','L','O'),"ELO Sistemas Eletronicos, Brazil")\
X(ELQ,MANFCODE('E','L','Q'),"ELEQ, Germany")\
X(ELR,MANFCODE('E','L','R'),"Elster Metering, United Kingdom")\
X(ELS,MANFCODE('E','L','S'),"Elster, Germany")\
X(ELT,MANFCODE('E','L','T'),"ELTAKO, Germany")\
X(ELV,MANFCODE('E','L','V'),"Elvaco, Sweden")\
X(EMB,MANFCODE('E','M','B'),"Embit, Italy")\
X(EMC,MANFCODE('E','M','C'),"Embedded Communication Systems, Switzerland")\
X(EME,MANFCODE('E','M','E'),"SC Electromagnetica, Romania")\
X(EMF,MANFCODE('E','M','F'),"IT Beratung Energiemanagement Flammang, Germany")\
X(EMH,MANFCODE('E','M','H'),"EMH metering formerly EMH Elektrizitatszahler")\
X(EMI,MANFCODE('E','M','I'),"Entorno Inteligente de Medicion, Spain")\
X(EML,MANFCODE('E','M','L'),"Emlite, United Kingdom")\
X(EMM,MANFCODE('E','M','M'),"Email Metering, Australia")\
X(EMO,MANFCODE('E','M','O'),"Enermet")\
X(EMR,MANFCODE('E','M','R'),"CJSC Energomera, Russian Federation")\
X(EMS,MANFCODE('E','M','S'),"EMS PATVAG, Switzerland")\
X(EMT,MANFCODE('E','M','T'),"Elster Messtechnik, Germany")\
X(EMU,MANFCODE('E','M','U'),"EMU Elektronik, Switzerland")\
X(END,MANFCODE('E','N','D'),"ENDYS")\
X(ENE,MANFCODE('E','N','E'),"ENERDIS, France")\
X(ENG,MANFCODE('E','N','G'),"ENER G Switch, United Kingdom")\
X(ENH,MANFCODE('E','N','H'),"ENMAS, Germany")\
X(ENI,MANFCODE('E','N','I'),"entec innovations, Germany")\
X(ENL,MANFCODE('E','N','L'),"ENEL, Serbia")\
X(ENN,MANFCODE('E','N','N'),"Enernet, South Korea")\
X(ENO,MANFCODE('E','N','O'),"ennovatis, Germany")\
X(ENP,MANFCODE('E','N','P'),"Kiev Polytechnical Scientific Research")\
X(ENR,MANFCODE('E','N','R'),"Energisme")\
X(ENS,MANFCODE('E','N','S'),"ENSO NETZ, Germany")\
X(ENT,MANFCODE('E','N','T'),"ENTES Elektronik, Turkey")\
X(ENX,MANFCODE('E','N','X'),"Enetronx, Germany")\
X(EPI,MANFCODE('E','P','I'),"EPI USE AFRICA, South Africa")\
X(EPL,MANFCODE('E','P','L'),"Escorts, Pakistan")\
X(ERE,MANFCODE('E','R','E'),"Enermatics Energy, South Africa")\
X(ERI,MANFCODE('E','R','I'),"Easun Reyrolle, India")\
X(ERL,MANFCODE('E','R','L'),"Erelsan Elektrik ve Elektronik, Turkey")\
X(ERN,MANFCODE('E','R','N'),"Ericsson Telecomunicazioni, Italy")\
X(ERS,MANFCODE('E','R','S'),"Eurosys, Bulgaria")\
X(ESA,MANFCODE('E','S','A'),"ESAC, Italy")\
X(ESC,MANFCODE('E','S','C'),"EDMI Shenzhen, China")\
X(ESD,MANFCODE('E','S','D'),"Edelstrom Electronic Devices and Designing, United Arab Emirates")\
X(ESE,MANFCODE('E','S','E'),"ESE Nordic, Sweden")\
X(ESG,MANFCODE('E','S','G'),"ESG, South Korea")\
X(ESH,MANFCODE('E','S','H'),"EMSYCON, Germany")\
X(ESI,MANFCODE('E','S','I'),"Monosan Monofaze Elektrik Motorlari, Turkey")\
X(ESM,MANFCODE('E','S','M'),"Monosan Monofaze Elektrik Motorlari, Turkey")\
X(ESN,MANFCODE('E','S','N'),"Zhejiang Eastron Electronic, China")\
X(ESO,MANFCODE('E','S','O'),"Monosan Monofaze Elektrik Motorlari, Turkey")\
X(ESP,MANFCODE('E','S','P'),"EFICAA ENSMART SOLUTIONS, India")\
X(ESR,MANFCODE('E','S','R'),"Ensor, Switzerland")\
X(ESS,MANFCODE('E','S','S'),"Energy Saving Systems, Ukraine")\
X(ESV,MANFCODE('E','S','V'),"ESKA VALVE, Turkey")\
X(ESY,MANFCODE('E','S','Y'),"EasyMeter")\
X(ETD,MANFCODE('E','T','D'),"Energy Team, Italy")\
X(ETK,MANFCODE('E','T','K'),"ELTEK BROJILA, Croatia")\
X(ETO,MANFCODE('E','T','O'),"Sphere of economical technologies, Russian Federation")\
X(ETP,MANFCODE('E','T','P'),"Energotechnica")\
X(EUE,MANFCODE('E','U','E'),"E E Electronic, Austria")\
X(EUR,MANFCODE('E','U','R'),"Eurometers")\
X(EUS,MANFCODE('E','U','S'),"Ebeling und Sohn, Germany")\
X(EVD,MANFCODE('E','V','D'),"DREWAG NETZ, Germany")\
X(EVK,MANFCODE('E','V','K'),"EV KUR ELEKTRIK, Turkey")\
X(EVL,MANFCODE('E','V','L'),"Geothermique, United Kingdom")\
X(EWA,MANFCODE('E','W','A'),"EWATTCH, France")\
X(EWG,MANFCODE('E','W','G'),"EWG DOO, Serbia")\
X(EWS,MANFCODE('E','W','S'),"ENLESS WIRELESS")\
X(EWT,MANFCODE('E','W','T'),"Elin Wasserwerkstechnik")\
X(EXS,MANFCODE('E','X','S'),"exceeding solutions, Germany")\
X(EXT,MANFCODE('E','X','T'),"LOTRIC Metrology, Slovenia")\
X(EYE,MANFCODE('E','Y','E'),"Eco eye, United Kingdom")\
X(EYT,MANFCODE('E','Y','T'),"Enerlyt Potsdam")\
X(FAE,MANFCODE('F','A','E'),"Fae Technology Company, Brazil")\
X(FAN,MANFCODE('F','A','N'),"Fantini Cosmi, Italy")\
X(FAR,MANFCODE('F','A','R'),"FARAB, Iran")\
X(FAS,MANFCODE('F','A','S'),"FAST, Italy")\
X(FED,MANFCODE('F','E','D'),"Federal Elektrik, Turkey")\
X(FEM,MANFCODE('F','E','M'),"Fortune Electric, Taiwan")\
X(FFD,MANFCODE('F','F','D'),"Fast Forward, Germany")\
X(FID,MANFCODE('F','I','D'),"Fi Muhendislik, Turkey")\
X(FIM,MANFCODE('F','I','M'),"Frodexim, Bulgaria")\
X(FIN,MANFCODE('F','I','N'),"Finder, Germany")\
X(FIO,MANFCODE('F','I','O'),"Pietro Fiorentini, Italy")\
X(FLA,MANFCODE('F','L','A'),"FLASH ELECTRONICS, India")\
X(FLD,MANFCODE('F','L','D'),"Fludia, France")\
X(FLE,MANFCODE('F','L','E'),"XIAN FLAG ELECTRONIC, China")\
X(FLG,MANFCODE('F','L','G'),"FLOMAG, Czech Republic")\
X(FLO,MANFCODE('F','L','O'),"Flonidan, Denmark")\
X(FLS,MANFCODE('F','L','S'),"FLASH o s, Turkey")\
X(FLU,MANFCODE('F','L','U'),"SHANDONG FEILONG INSTRUMENT, China")\
X(FLW,MANFCODE('F','L','W'),"Fluidwell, Netherlands")\
X(FLX,MANFCODE('F','L','X'),"FLEXIM Flexible Industriemesstechnik, Germany")\
X(FMG,MANFCODE('F','M','G'),"Flow Meter Group, Netherlands")\
X(FML,MANFCODE('F','M','L'),"Siemens Measurements Formerly FML")\
X(FMM,MANFCODE('F','M','M'),"F IMM, Italy")\
X(FNX,MANFCODE('F','N','X'),"Flownetix, United Kingdom")\
X(FPL,MANFCODE('F','P','L'),"fifthplay, Belgium")\
X(FPR,MANFCODE('F','P','R'),"F Pribor, Belarus")\
X(FRC,MANFCODE('F','R','C'),"Friendcom Technology")\
X(FRE,MANFCODE('F','R','E'),"Frer, Italy")\
X(FRU,MANFCODE('F','R','U'),"OJSC NRPA FRUNZE, Russian Federation")\
X(FSP,MANFCODE('F','S','P'),"Finmek Space, Italy")\
X(FST,MANFCODE('F','S','T'),"FieldServer Technologies, United States of America")\
X(FSY,MANFCODE('F','S','Y'),"FlowService, Poland")\
X(FTL,MANFCODE('F','T','L'),"Tritschler, Germany")\
X(FUS,MANFCODE('F','U','S'),"Fuccesso, China")\
X(FUT,MANFCODE('F','U','T'),"first utility, United Kingdom")\
X(FWS,MANFCODE('F','W','S'),"FW Systeme, Germany")\
X(FZK,MANFCODE('F','Z','K'),"FUNZIN, South Korea")\
X(GAT,MANFCODE('G','A','T'),"GEPDEC SMART TECHNOLOGY, India")\
X(GAV,MANFCODE('G','A','V'),"Carlo Gavazzi Controls, Italy")\
X(GBJ,MANFCODE('G','B','J'),"Grundfoss")\
X(GCE,MANFCODE('G','C','E'),"Genergica, Venezuela")\
X(GCG,MANFCODE('G','C','G'),"Goldcard Smart Group, China")\
X(GDC,MANFCODE('G','D','C'),"GADICO TECNOLOGIAA")\
X(GDS,MANFCODE('G','D','S'),"InnoSense, Switzerland")\
X(GEC,MANFCODE('G','E','C'),"GEC Meters")\
X(GEE,MANFCODE('G','E','E'),"GE Energy, United Kingdom")\
X(GEL,MANFCODE('G','E','L'),"Industrial Technology Research Institute, Taiwan")\
X(GEN,MANFCODE('G','E','N'),"Goerlitz")\
X(GEO,MANFCODE('G','E','O'),"Green Energy Options, United Kingdom")\
X(GEP,MANFCODE('G','E','P'),"GEPDEC INFRATECH")\
X(GET,MANFCODE('G','E','T'),"Genus Electrotech, India")\
X(GEX,MANFCODE('G','E','X'),"Global Evolution Lighting, Tunisia")\
X(GFM,MANFCODE('G','F','M'),"GE Fuji Meter, Japan")\
X(GIL,MANFCODE('G','I','L'),"Genus Innovations, India")\
X(GIN,MANFCODE('G','I','N'),"Gineers, Bulgaria")\
X(GIO,MANFCODE('G','I','O'),"G GIOANOLA, Italy")\
X(GLM,MANFCODE('G','L','M'),"GETRALINE, France")\
X(GLX,MANFCODE('G','L','X'),"Electrical Equipment Joint Stock Corporation, Vietnam")\
X(GMC,MANFCODE('G','M','C'),"GMC I Messtechnik, Germany")\
X(GME,MANFCODE('G','M','E'),"Global Metering Electronics, Netherlands")\
X(GMM,MANFCODE('G','M','M'),"Gamma International, Egypt")\
X(GMS,MANFCODE('G','M','S'),"Gity Madara Sepahan, Iran")\
X(GMT,MANFCODE('G','M','T'),"GMT, Germany")\
X(GNP,MANFCODE('G','N','P'),"GEPDEC ENERGY, India")\
X(GNY,MANFCODE('G','N','Y'),"JiangSu GuoNeng Instrument Technology, China")\
X(GOE,MANFCODE('G','O','E'),"Genus Power Infrastructures, India")\
X(GPM,MANFCODE('G','P','M'),"Gram Power, India")\
X(GRA,MANFCODE('G','R','A'),"Graesslin, Germany")\
X(GRD,MANFCODE('G','R','D'),"Greenradio")\
X(GRE,MANFCODE('G','R','E'),"GE2 Green Energy Electronics, Portugal")\
X(GRI,MANFCODE('G','R','I'),"Grinpal Energy Management, South Africa")\
X(GRP,MANFCODE('G','R','P'),"GlobalRnD, Poland")\
X(GRS,MANFCODE('G','R','S'),"Garderos, Germany")\
X(GRX,MANFCODE('G','R','X'),"Gurux, Finland")\
X(GSE,MANFCODE('G','S','E'),"Gridspertise, Italy")\
X(GSP,MANFCODE('G','S','P'),"Ingenieurbuero Gasperowicz")\
X(GSS,MANFCODE('G','S','S'),"R D Gran System S, Belarus")\
X(GST,MANFCODE('G','S','T'),"Shenzhen Golden Square Technology, China")\
X(GTE,MANFCODE('G','T','E'),"GREATech, Germany")\
X(GTM,MANFCODE('G','T','M'),"G2 misuratori, Italy")\
X(GTR,MANFCODE('G','T','R'),"Globaltronics for Electronics E, Egypt")\
X(GTS,MANFCODE('G','T','S'),"GIGATRONIK Stuttgart, Germany")\
X(GUH,MANFCODE('G','U','H'),"ShenZhen GuangNing Industrial, China")\
X(GWF,MANFCODE('G','W','F'),"Gas u Wassermesserfabrik, Switzerland")\
X(GWI,MANFCODE('G','W','I'),"George Wilson Industries Aldermans Green Industrial Estate, United Kingdom")\
X(HAG,MANFCODE('H','A','G'),"Hager Electro, Germany")\
X(HAK,MANFCODE('H','A','K'),"Hako, Slovakia")\
X(HBY,MANFCODE('H','B','Y'),"HENAN HUABIAO INSTRUMENT TECHNOLOGY, China")\
X(HCE,MANFCODE('H','C','E'),"Hsiang Cheng Electric, China")\
X(HCM,MANFCODE('H','C','M'),"Hidroconta U, Spain")\
X(HDK,MANFCODE('H','D','K'),"Hydroko, Belgium")\
X(HDX,MANFCODE('H','D','X'),"Beijing TianRuiXiangDe Measuring Technology, China")\
X(HDY,MANFCODE('H','D','Y'),"Dalian hundao instrument, China")\
X(HEG,MANFCODE('H','E','G'),"Hamburger Elektronik Gesellschaft")\
X(HEI,MANFCODE('H','E','I'),"Hydro Eco Invest, Poland")\
X(HEK,MANFCODE('H','E','K'),"Hexing Technology Company, Kenya")\
X(HEL,MANFCODE('H','E','L'),"Heliowatt")\
X(HEM,MANFCODE('H','E','M'),"Hokkaido Electric Meter Industry, Japan")\
X(HER,MANFCODE('H','E','R'),"Hermes Systems, Australia")\
X(HEW,MANFCODE('H','E','W'),"Honeywell Integrated Technology, China")\
X(HEX,MANFCODE('H','E','X'),"Shenzhen Hexcell Electronics Technology, China")\
X(HFI,MANFCODE('H','F','I'),"Nanjing Hu Measurement Control Technology, China")\
X(HFL,MANFCODE('H','F','L'),"HFIL Technologies")\
X(HFR,MANFCODE('H','F','R'),"SAERI HEAT METERING TECHNOLOGY, China")\
X(HGM,MANFCODE('H','G','M'),"HG meter, Denmark")\
X(HHE,MANFCODE('H','H','E'),"HAUSHELD, Germany")\
X(HHM,MANFCODE('H','H','M'),"Chongqing Huahong Metering, China")\
X(HIE,MANFCODE('H','I','E'),"Shenzhen Holley South Electronics Technology, China")\
X(HIN,MANFCODE('H','I','N'),"huebner Informationselektronik, Germany")\
X(HIT,MANFCODE('H','I','T'),"ABB, Poland")\
X(HJM,MANFCODE('H','J','M'),"Huaihua Jiannan Machinery Factory, China")\
X(HKK,MANFCODE('H','K','K'),"Hokuriku Instrumentation, Japan")\
X(HLY,MANFCODE('H','L','Y'),"Holley Metering")\
X(HMI,MANFCODE('H','M','I'),"HMI Energy, Taiwan")\
X(HML,MANFCODE('H','M','L'),"Holley Technology, China")\
X(HMS,MANFCODE('H','M','S'),"Hermes Systems, Australia")\
X(HMT,MANFCODE('H','M','T'),"Hangzhou Meteronic Technology, China")\
X(HMU,MANFCODE('H','M','U'),"Hugo Muller, Germany")\
X(HND,MANFCODE('H','N','D'),"Shenzhen Hemei Group, China")\
X(HOE,MANFCODE('H','O','E'),"HOENTZSCH, Germany")\
X(HOL,MANFCODE('H','O','L'),"Holosys, Croatia")\
X(HON,MANFCODE('H','O','N'),"Honeywell Technologies, Switzerland")\
X(HOY,MANFCODE('H','O','Y'),"Holley Meters, India")\
X(HPL,MANFCODE('H','P','L'),"HPL Socomec, India")\
X(HPM,MANFCODE('H','P','M'),"HANGZHOU HPM COMPANY, China")\
X(HRM,MANFCODE('H','R','M'),"Hefei Runa Metering, China")\
X(HRS,MANFCODE('H','R','S'),"HomeRider, France")\
X(HSD,MANFCODE('H','S','D'),"Ningbo Histar Meter Technology, China")\
X(HST,MANFCODE('H','S','T'),"HST Equipamentos Electronicosa")\
X(HTC,MANFCODE('H','T','C'),"Horstmann Timers and Controls")\
X(HTI,MANFCODE('H','T','I'),"Shandong Hetong Information Technology, China")\
X(HTL,MANFCODE('H','T','L'),"Ernst Heitland Erlenstr, Germany")\
X(HTS,MANFCODE('H','T','S'),"HTS Elektronik")\
X(HUK,MANFCODE('H','U','K'),"Helbeck Kusemann, Germany")\
X(HUM,MANFCODE('H','U','M'),"Humanlitech, Ghana")\
X(HVG,MANFCODE('H','V','G'),"Hekatron Vertriebs, Germany")\
X(HVT,MANFCODE('H','V','T'),"Helvatron, Switzerland")\
X(HWC,MANFCODE('H','W','C'),"Qingdao Hiwits Meter, China")\
X(HWM,MANFCODE('H','W','M'),"Beijing Hongwei Chaoda Instrument Manufacturing, China")\
X(HWT,MANFCODE('H','W','T'),"Huawei Technologies, China")\
X(HXD,MANFCODE('H','X','D'),"Beijing HongHaoXingDa Meters, China")\
X(HXE,MANFCODE('H','X','E'),"Hexing Electrical, China")\
X(HXW,MANFCODE('H','X','W'),"Hangzhou Xili Watthour Meter Manufacture, China")\
X(HYD,MANFCODE('H','Y','D'),"Hydrometer")\
X(HYE,MANFCODE('H','Y','E'),"Zhejiang Hyayi Electronic Industry, China")\
X(HYG,MANFCODE('H','Y','G'),"Hydrometer Group, Germany")\
X(HYS,MANFCODE('H','Y','S'),"Hydrelis")\
X(HZC,MANFCODE('H','Z','C'),"TANGSHAN HUIZHONG INSTRUMENTATION, China")\
X(HZI,MANFCODE('H','Z','I'),"TANGSHAN HUIZHONG INSTRUMENTATION, China")\
X(HZZ,MANFCODE('H','Z','Z'),"Huizhou Zhongcheng Electronic Technology, China")\
X(IAC,MANFCODE('I','A','C'),"INHEMETER AFRICA COMPANY, Kenya")\
X(IBE,MANFCODE('I','B','E'),"IBOT ENERGY SYSTEMS, India")\
X(IBG,MANFCODE('I','B','G'),"ITI BANGALORE PLANT, India")\
X(ICB,MANFCODE('I','C','B'),"Inscobee, South Korea")\
X(ICE,MANFCODE('I','C','E'),"Icoal incorporated, United States of America")\
X(ICK,MANFCODE('I','C','K'),"I C Technology, South Korea")\
X(ICM,MANFCODE('I','C','M'),"Intracom, Greece")\
X(ICP,MANFCODE('I','C','P'),"PT Comnets Plus, Indonesia")\
X(ICS,MANFCODE('I','C','S'),"ICSA, India")\
X(ICT,MANFCODE('I','C','T'),"International Control Metering Technologies, Germany")\
X(ICU,MANFCODE('I','C','U'),"i cube, Switzerland")\
X(IDE,MANFCODE('I','D','E'),"IMIT")\
X(IDS,MANFCODE('I','D','S'),"IDS, Germany")\
X(IEC,MANFCODE('I','E','C'),"leonnardo Corporation, Ukraine")\
X(IEE,MANFCODE('I','E','E'),"I E Electromatic, Spain")\
X(IEI,MANFCODE('I','E','I'),"Informage Energy, India")\
X(IEN,MANFCODE('I','E','N'),"Institute of Power Engineering, Poland")\
X(IES,MANFCODE('I','E','S'),"Integrated Electronic Systems Lab, China")\
X(IFC,MANFCODE('I','F','C'),"infocon, Montenegro")\
X(IFX,MANFCODE('I','F','X'),"Infineon Technologies, Germany")\
X(IGR,MANFCODE('I','G','R'),"iGridS Hebelweg, Germany")\
X(IGS,MANFCODE('I','G','S'),"I G S DATAFLOW, Italy")\
X(IHM,MANFCODE('I','H','M'),"Shenzhen Inhemeter, China")\
X(IID,MANFCODE('I','I','D'),"PT INDUSTRI TELEKOMUNIKASI Persero, Indonesia")\
X(IIF,MANFCODE('I','I','F'),"Westenergie Metering, Germany")\
X(IJE,MANFCODE('I','J','E'),"ILJIN Electric, South Korea")\
X(IJK,MANFCODE('I','J','K'),"IJENKO, France")\
X(IKE,MANFCODE('I','K','E'),"IK Elektronik Friedrichsgruener Str, Germany")\
X(IKM,MANFCODE('I','K','M'),"Ikom, Croatia")\
X(IKS,MANFCODE('I','K','S'),"IKASIAN, Spain")\
X(IMC,MANFCODE('I','M','C'),"madar, Iran")\
X(IME,MANFCODE('I','M','E'),"Fellows, Poland")\
X(IMR,MANFCODE('I','M','R'),"iMeter, Ukraine")\
X(IMS,MANFCODE('I','M','S'),"IMST, Germany")\
X(IMT,MANFCODE('I','M','T'),"INTEGRA METERING, Switzerland")\
X(IMZ,MANFCODE('I','M','Z'),"iMezr Innovations, India")\
X(INC,MANFCODE('I','N','C'),"Incotex, Russian Federation")\
X(IND,MANFCODE('I','N','D'),"INDRA SISTEMAS, Spain")\
X(INE,MANFCODE('I','N','E'),"INNOTAS Elektronik, Germany")\
X(INF,MANFCODE('I','N','F'),"Infometric, Sweden")\
X(INI,MANFCODE('I','N','I'),"Altero, Sweden")\
X(INM,MANFCODE('I','N','M'),"Inepro Metering, Netherlands")\
X(INN,MANFCODE('I','N','N'),"INNEXIV, United States of America")\
X(INO,MANFCODE('I','N','O'),"Indotech Switchgear Controls Delhi, India")\
X(INP,MANFCODE('I','N','P'),"INNOTAS Produktions, Germany")\
X(INS,MANFCODE('I','N','S'),"INSYS MICROELECTRONICS, Germany")\
X(INT,MANFCODE('I','N','T'),"Infranet Technologies, Germany")\
X(INV,MANFCODE('I','N','V'),"Sensus Metering Systems, Germany")\
X(INX,MANFCODE('I','N','X'),"Innolex Engineering, Netherlands")\
X(IOT,MANFCODE('I','O','T'),"Trilliant Networks, Canada")\
X(IPD,MANFCODE('I','P','D'),"IPD Industrial Products, Australia")\
X(IQO,MANFCODE('I','Q','O'),"Kwhiq, Netherlands")\
X(IQS,MANFCODE('I','Q','S'),"IQ Systems, South Africa")\
X(IRE,MANFCODE('I','R','E'),"IREN Energia, Italy")\
X(ISA,MANFCODE('I','S','A'),"Isabellenhutte Heusler, Germany")\
X(ISE,MANFCODE('I','S','E'),"INESH SMART ENERGY P, India")\
X(ISF,MANFCODE('I','S','F'),"Investcom Szymon Fiedorowicz, Poland")\
X(ISI,MANFCODE('I','S','I'),"Akcionarsko Drustvo Insa Industrija Satova, Serbia")\
X(ISK,MANFCODE('I','S','K'),"Iskraemeco, Slovenia")\
X(ISO,MANFCODE('I','S','O'),"Isoil Industria, Italy")\
X(ISS,MANFCODE('I','S','S'),"Iskra, Slovenia")\
X(IST,MANFCODE('I','S','T'),"Ista")\
X(ITA,MANFCODE('I','T','A'),"iTrona, Switzerland")\
X(ITB,MANFCODE('I','T','B'),"Itron Solucoes para Energia e Aguaa, Brazil")\
X(ITC,MANFCODE('I','T','C'),"INTECH TUNISIE, Tunisia")\
X(ITE,MANFCODE('I','T','E'),"ITRON Electricity, France")\
X(ITF,MANFCODE('I','T','F'),"ITF Froeschl, Germany")\
X(ITG,MANFCODE('I','T','G'),"ITRON Gas, France")\
X(ITH,MANFCODE('I','T','H'),"INTELTEH, Croatia")\
X(ITI,MANFCODE('I','T','I'),"ITRON Asia, Indonesia")\
X(ITK,MANFCODE('I','T','K'),"Itron, Germany")\
X(ITL,MANFCODE('I','T','L'),"Indriya Technologies, India")\
X(ITP,MANFCODE('I','T','P'),"M s ITI, India")\
X(ITR,MANFCODE('I','T','R'),"Itron")\
X(ITS,MANFCODE('I','T','S'),"ITRON Australasia, Australia")\
X(ITU,MANFCODE('I','T','U'),"ITRON United States Itron, United States of America")\
X(ITW,MANFCODE('I','T','W'),"ITRON Water, France")\
X(ITX,MANFCODE('I','T','X'),"IDEAL TECHNICAL SOLUTIONS, United Arab Emirates")\
X(ITZ,MANFCODE('I','T','Z'),"ITRON, South Africa")\
X(IUS,MANFCODE('I','U','S'),"IUSA DE CV, Mexico")\
X(IVY,MANFCODE('I','V','Y'),"IVY metering, China")\
X(IWD,MANFCODE('I','W','D'),"Inkwell Data, Ireland")\
X(IWK,MANFCODE('I','W','K'),"IWK Regler und Kompensatoren")\
X(IYI,MANFCODE('I','Y','I'),"KAYI ENERGY Hacettepe Universitesi, Turkey")\
X(IZE,MANFCODE('I','Z','E'),"iZenze, Sweden")\
X(JAC,MANFCODE('J','A','C'),"Jay Autocomponents, India")\
X(JAN,MANFCODE('J','A','N'),"Janitza electronics, Germany")\
X(JBF,MANFCODE('J','B','F'),"Beijing jingyibeifang instrument company")\
X(JCE,MANFCODE('J','C','E'),"Janz Contadores de Energia, Portugal")\
X(JED,MANFCODE('J','E','D'),"JED, South Korea")\
X(JGD,MANFCODE('J','G','D'),"tianjin guangdaweiye measuring instrument technology, China")\
X(JGF,MANFCODE('J','G','F'),"Janz Contagem e Gestao de Fluidos, Portugal")\
X(JGH,MANFCODE('J','G','H'),"ITSQUARE, South Korea")\
X(JHA,MANFCODE('J','H','A'),"Zhejiang JiaHe Instrument, China")\
X(JHM,MANFCODE('J','H','M'),"Changzhou Jianhu Intelligentize Meter, China")\
X(JJN,MANFCODE('J','J','N'),"BeiJing Fine Clean Enery Technology, China")\
X(JKW,MANFCODE('J','K','W'),"QingdaoJakewill Energy Technology, China")\
X(JMT,MANFCODE('J','M','T'),"JM TRONIC, Poland")\
X(JNC,MANFCODE('J','N','C'),"NINGBO JIANAN ELECTRONICS, China")\
X(JNJ,MANFCODE('J','N','J'),"JNJ POWERCOM SYSTEMS, India")\
X(JOY,MANFCODE('J','O','Y'),"Zhejiang Joy Electronic Technology, China")\
X(JSM,MANFCODE('J','S','M'),"Jining Goldwater Science Technology, China")\
X(JSO,MANFCODE('J','S','O'),"Schloesser Armaturen, Germany")\
X(JUM,MANFCODE('J','U','M'),"JUMO, Germany")\
X(JWH,MANFCODE('J','W','H'),"TIANJIN WANHUA, China")\
X(JWR,MANFCODE('J','W','R'),"Shandong jingwei telecommunications equipment, China")\
X(JWS,MANFCODE('J','W','S'),"Wesson energy saving technology tianjin, China")\
X(JYS,MANFCODE('J','Y','S'),"Beijing Jingyuan instrument company, China")\
X(KAA,MANFCODE('K','A','A'),"Kamstrup, Denmark")\
X(KAC,MANFCODE('K','A','C'),", Russian Federation")\
X(KAL,MANFCODE('K','A','L'),"Kallenbach Elektronik")\
X(KAM,MANFCODE('K','A','M'),"Kamstrup Energi")\
X(KAR,MANFCODE('K','A','R'),"Keskar Vana Metal Mak Sti, Turkey")\
X(KAS,MANFCODE('K','A','S'),"Kamstrup, Denmark")\
X(KAT,MANFCODE('K','A','T'),"KATHREIN Werke, Germany")\
X(KAW,MANFCODE('K','A','W'),"Kamstrup, Denmark")\
X(KBH,MANFCODE('K','B','H'),"K Biesinger, Germany")\
X(KBK,MANFCODE('K','B','K'),"KBK ELECTRONICS, Pakistan")\
X(KBN,MANFCODE('K','B','N'),"Alpamis IT, Turkey")\
X(KDN,MANFCODE('K','D','N'),"KADEN VODOMERY, Czech Republic")\
X(KDS,MANFCODE('K','D','S'),"Kedros, Slovakia")\
X(KEE,MANFCODE('K','E','E'),"Keewe, Bulgaria")\
X(KEL,MANFCODE('K','E','L'),"KELEMINIC, Croatia")\
X(KER,MANFCODE('K','E','R'),"KERMS haftungsbeschraenkt, Germany")\
X(KES,MANFCODE('K','E','S'),"Kavosh Electronic Sepahan, Iran")\
X(KFM,MANFCODE('K','F','M'),"Shenzhen Kaifa Technology, China")\
X(KFM,MANFCODE('K','F','M'),"Shenzhen Kaifa Technology Chengdu, China")\
X(KGE,MANFCODE('K','G','E'),"Guangzhou Keli General Electric, China")\
X(KHL,MANFCODE('K','H','L'),"Kohler, Turkey")\
X(KIG,MANFCODE('K','I','G'),"Kiwigrid Kleiststrasse, Germany")\
X(KJN,MANFCODE('K','J','N'),"Radniroo Industrial")\
X(KKE,MANFCODE('K','K','E'),"KK Electronic")\
X(KLE,MANFCODE('K','L','E'),"SHIJIAZHUANG KELIN ELECTRIC, China")\
X(KLK,MANFCODE('K','L','K'),"Kerlink, France")\
X(KMB,MANFCODE('K','M','B'),"Kamstrup, Denmark")\
X(KMT,MANFCODE('K','M','T'),"Krohne Messtechnik, Germany")\
X(KNI,MANFCODE('K','N','I'),"zhangzhou keneng electrical equipment, China")\
X(KNX,MANFCODE('K','N','X'),"KONNEX based users Siemens Regensburg")\
X(KPD,MANFCODE('K','P','D'),"Korea Electric Power Industrial Development, South Korea")\
X(KRO,MANFCODE('K','R','O'),"Kromschroder")\
X(KRT,MANFCODE('K','R','T'),"Karat, Russian Federation")\
X(KSM,MANFCODE('K','S','M'),"Korea Testing Certification, South Korea")\
X(KST,MANFCODE('K','S','T'),"Kundo SystemTechnik")\
X(KSY,MANFCODE('K','S','Y'),"KUNDO SystemTechnik, Germany")\
X(KTC,MANFCODE('K','T','C'),"Kerman Tablo, Iran")\
X(KZK,MANFCODE('K','Z','K'),"KRIZIK, Czech Republic")\
X(LAC,MANFCODE('L','A','C'),"Heinz Lackmann, Germany")\
X(LAI,MANFCODE('L','A','I'),"Hangzhou LAISON Technology, China")\
X(LAN,MANFCODE('L','A','N'),"Langmatz, Germany")\
X(LAS,MANFCODE('L','A','S'),"Lansen Systems, Sweden")\
X(LCG,MANFCODE('L','C','G'),"Landis Gyr Meter System Zhuhai, China")\
X(LCR,MANFCODE('L','C','R'),"ShanDong LiChuang Science and Technology, China")\
X(LDE,MANFCODE('L','D','E'),"Shenzhen Londian Electrics, China")\
X(LEC,MANFCODE('L','E','C'),"Lectrotek Systems, India")\
X(LEI,MANFCODE('L','E','I'),"PCP International, India")\
X(LEM,MANFCODE('L','E','M'),"LEM HEME, United Kingdom")\
X(LES,MANFCODE('L','E','S'),"Lakshmi Electrical Control Systems, India")\
X(LET,MANFCODE('L','E','T'),"LAN ENGINEERING TECHNOLOGIES, India")\
X(LFS,MANFCODE('L','F','S'),"Payolcer Metering Devices, Turkey")\
X(LGA,MANFCODE('L','G','A'),"Landis Gyr")\
X(LGB,MANFCODE('L','G','B'),"Landis Gyr, United Kingdom")\
X(LGC,MANFCODE('L','G','C'),"Landis Gyr Equipamentos de Medicaoa Brasil, Brazil")\
X(LGD,MANFCODE('L','G','D'),"Landis Gyr, Germany")\
X(LGF,MANFCODE('L','G','F'),"Landis Gyr, Finland")\
X(LGG,MANFCODE('L','G','G'),"Ningxia LGG Instrument, China")\
X(LGI,MANFCODE('L','G','I'),"Landis Gyr, India")\
X(LGS,MANFCODE('L','G','S'),"Landis Gyr, South Africa")\
X(LGU,MANFCODE('L','G','U'),"LG Uplus, South Korea")\
X(LGZ,MANFCODE('L','G','Z'),"Landis Gyr, Switzerland")\
X(LHA,MANFCODE('L','H','A'),"Atlantic Meters, South Africa")\
X(LIN,MANFCODE('L','I','N'),"Ever Meter, Myanmar")\
X(LIT,MANFCODE('L','I','T'),"Punos Electronic, Sweden")\
X(LJP,MANFCODE('L','J','P'),"Lars Jansen Productions, Netherlands")\
X(LLM,MANFCODE('L','L','M'),"LianYunGang LianLi First Meter, China")\
X(LMC,MANFCODE('L','M','C'),"Lumacol, Slovakia")\
X(LMG,MANFCODE('L','M','G'),"Luftmeister, Germany")\
X(LML,MANFCODE('L','M','L'),"LUMEL, Poland")\
X(LMP,MANFCODE('L','M','P'),"LIN MAN POWER TECHNOLOGY, Philippines")\
X(LMS,MANFCODE('L','M','S'),"LMS Services, Germany")\
X(LNC,MANFCODE('L','N','C'),"Lancier Monitoring, Germany")\
X(LNK,MANFCODE('L','N','K'),"Loenk F, South Korea")\
X(LNT,MANFCODE('L','N','T'),"Schneider Electric, India")\
X(LOB,MANFCODE('L','O','B'),"Lobaro, Germany")\
X(LOG,MANFCODE('L','O','G'),"LOGAREX Smart Metering, Czech Republic")\
X(LOV,MANFCODE('L','O','V'),"Lovato Electric, Italy")\
X(LSC,MANFCODE('L','S','C'),"Lund Science, Sweden")\
X(LSE,MANFCODE('L','S','E'),"Landis Staefa electronic")\
X(LSK,MANFCODE('L','S','K'),"LS Industrial Systems, South Korea")\
X(LSP,MANFCODE('L','S','P'),"Landis Gyr, Germany")\
X(LSZ,MANFCODE('L','S','Z'),"Siemens Building Technologies")\
X(LTO,MANFCODE('L','T','O'),"Labtrino, Sweden")\
X(LUG,MANFCODE('L','U','G'),"Landis Gyr, Germany")\
X(LUN,MANFCODE('L','U','N'),"LUNA Elektrik Elektronik, Turkey")\
X(LWT,MANFCODE('L','W','T'),"Lotus Wireless Technologies, India")\
X(LYE,MANFCODE('L','Y','E'),"Jiangsu Linyang Electronics, China")\
X(MAC,MANFCODE('M','A','C'),"RUDNAP Group Meter Control, Serbia")\
X(MAD,MANFCODE('M','A','D'),"Maddalena, Italy")\
X(MAE,MANFCODE('M','A','E'),"Mates Elektronik Metin Ates, Turkey")\
X(MAG,MANFCODE('M','A','G'),"MAGNATECH Smart Grid Solutions, India")\
X(MAH,MANFCODE('M','A','H'),"MAHAM ELECTRONIC SAMA SANAT")\
X(MAN,MANFCODE('M','A','N'),"Manthey, Germany")\
X(MAT,MANFCODE('M','A','T'),"Mitsubishi Electric Automation, Thailand")\
X(MAX,MANFCODE('M','A','X'),"MAXMET, South Korea")\
X(MBS,MANFCODE('M','B','S'),"MBS, Germany")\
X(MCP,MANFCODE('M','C','P'),"MPSE, Germany")\
X(MCR,MANFCODE('M','C','R'),"MICRORISC, Czech Republic")\
X(MCS,MANFCODE('M','C','S'),"MetCom Solutions, Germany")\
X(MDA,MANFCODE('M','D','A'),"PT MELCOINDA, Indonesia")\
X(MDE,MANFCODE('M','D','E'),"Diehl Metering Deutschland, Germany")\
X(MDL,MANFCODE('M','D','L'),"Maddalena, Italy")\
X(MDX,MANFCODE('M','D','X'),"mdex, Germany")\
X(MEC,MANFCODE('M','E','C'),"Mitsubishi Electric Corporation, Japan")\
X(MED,MANFCODE('M','E','D'),"MAHARASHTRA STATE ELECTRICITY DISTRIBUTION COMPANY, India")\
X(MEE,MANFCODE('M','E','E'),"Metron Europe, France")\
X(MEH,MANFCODE('M','E','H'),"Mueller electronic, Germany")\
X(MEI,MANFCODE('M','E','I'),"Sensus Metering Systems, Germany")\
X(MEL,MANFCODE('M','E','L'),"Mikroelektronika a d, Bosnia and Herzegovina")\
X(MEM,MANFCODE('M','E','M'),"MEMS, Switzerland")\
X(MES,MANFCODE('M','E','S'),"Electrometer U, Spain")\
X(MET,MANFCODE('M','E','T'),"METRA Energie Messtechnik, Germany")\
X(MHT,MANFCODE('M','H','T'),"Mechatronic Meters, Italy")\
X(MIC,MANFCODE('M','I','C'),"Microtronics Engineering, Austria")\
X(MID,MANFCODE('M','I','D'),"MiDo, Italy")\
X(MII,MANFCODE('M','I','I'),"Apator Miitors ApS, Denmark")\
X(MIJ,MANFCODE('M','I','J'),"MAXWELL, India")\
X(MIK,MANFCODE('M','I','K'),"Mikroklima, Czech Republic")\
X(MIL,MANFCODE('M','I','L'),"Milur Smart System liability company, Russian Federation")\
X(MIM,MANFCODE('M','I','M'),"n Intelligence Meters Sdn Bhd, Malaysia")\
X(MIR,MANFCODE('M','I','R'),"MIR Research and Production Association, Russian Federation")\
X(MIS,MANFCODE('M','I','S'),"Iskra MIS, Slovenia")\
X(MIT,MANFCODE('M','I','T'),"Sagemcom Energy Telecom, France")\
X(MKA,MANFCODE('M','K','A'),"mirakonta, Germany")\
X(MKE,MANFCODE('M','K','E'),"MKEK Genel Mudurlugu Gazi Fisek ELSA, Turkey")\
X(MKL,MANFCODE('M','K','L'),"MAKEL Elektrik Malzemeleri, Turkey")\
X(MKS,MANFCODE('M','K','S'),"MAK SAY Elektrik Elektronik, Turkey")\
X(MLQ,MANFCODE('M','L','Q'),"MeterLinq, Italy")\
X(MLR,MANFCODE('M','L','R'),"PKK Milandr, Russian Federation")\
X(MMC,MANFCODE('M','M','C'),"Modern Meters, Syria")\
X(MMF,MANFCODE('M','M','F'),"MEMF Electrical Industries, Saudi Arabia")\
X(MMI,MANFCODE('M','M','I'),"MyMeterInfo, France")\
X(MMM,MANFCODE('M','M','M'),"MATRICA")\
X(MMP,MANFCODE('M','M','P'),"MATRIXMETERS, India")\
X(MMS,MANFCODE('M','M','S'),"Brunswick Bowling and Billiards UK, United Kingdom")\
X(MMT,MANFCODE('M','M','T'),"METMOTEC, United Kingdom")\
X(MNS,MANFCODE('M','N','S'),"MANAS Elektronik, Turkey")\
X(MNW,MANFCODE('M','N','W'),"MENOWATT GE, Italy")\
X(MOJ,MANFCODE('M','O','J'),"Mojec International, Nigeria")\
X(MOS,MANFCODE('M','O','S'),"MOMAS SYSTEMS, Nigeria")\
X(MOT,MANFCODE('M','O','T'),"The Motwane Manufacturing Company, India")\
X(MPA,MANFCODE('M','P','A'),"Mega Power Automation International, Hong Kong")\
X(MPR,MANFCODE('M','P','R'),"Michael Rac, Germany")\
X(MPS,MANFCODE('M','P','S'),"Multiprocessor Systems, Bulgaria")\
X(MRN,MANFCODE('M','R','N'),"LLC RPC MEtRON, Ukraine")\
X(MRT,MANFCODE('M','R','T'),"MIRTEK, Russian Federation")\
X(MSB,MANFCODE('M','S','B'),"MISA SDN BHD, Malaysia")\
X(MSE,MANFCODE('M','S','E'),"Mahashakti Energy, India")\
X(MSM,MANFCODE('M','S','M'),"MS M, South Korea")\
X(MSO,MANFCODE('M','S','O'),"Metiso, Serbia")\
X(MST,MANFCODE('M','S','T'),"Microsoft Corporation, Taiwan")\
X(MSY,MANFCODE('M','S','Y'),"MAK SAY Elektrik Elektronik Malzemeleri, Turkey")\
X(MTC,MANFCODE('M','T','C'),"Metering Technology Corporation")\
X(MTD,MANFCODE('M','T','D'),"Removed November, United States of America")\
X(MTH,MANFCODE('M','T','H'),"njmeter, China")\
X(MTI,MANFCODE('M','T','I'),"Microtech Industries, Pakistan")\
X(MTL,MANFCODE('M','T','L'),"Advance Metering technology, India")\
X(MTM,MANFCODE('M','T','M'),"Metrum, Sweden")\
X(MTN,MANFCODE('M','T','N'),"Merytronic, Spain")\
X(MTP,MANFCODE('M','T','P'),"Modern Transformers, India")\
X(MTR,MANFCODE('M','T','R'),"METER, Russian Federation")\
X(MTS,MANFCODE('M','T','S'),"MeteRSit, Italy")\
X(MTX,MANFCODE('M','T','X'),"Matrix Energy, India")\
X(MUK,MANFCODE('M','U','K'),"Meters UK Whitegate White Lund Trading Estate, United Kingdom")\
X(MWI,MANFCODE('M','W','I'),"Magic Wand Intelligent Systems, India")\
X(MWU,MANFCODE('M','W','U'),"METRONA Union, Germany")\
X(MXM,MANFCODE('M','X','M'),"Maxim Integrated Circuit Design, India")\
X(MYS,MANFCODE('M','Y','S'),"MODEMSYS, Spain")\
X(NAE,MANFCODE('N','A','E'),"Nanjing NengRui Automation Equipment, China")\
X(NAR,MANFCODE('N','A','R'),"NARI Group Corporation NARI Technology Development, China")\
X(NAS,MANFCODE('N','A','S'),"NAS Instruments OU, Estonia")\
X(NAS,MANFCODE('N','A','S'),"NAS Instruments OU")\
X(NAT,MANFCODE('N','A','T'),"Natural Heat Ahorro Energetico, Spain")\
X(NCK,MANFCODE('N','C','K'),"NC Korea, South Korea")\
X(NDF,MANFCODE('N','D','F'),"NUCLEO DURO FELGUERA, Spain")\
X(NDM,MANFCODE('N','D','M'),"Northern Design, United Kingdom")\
X(NEE,MANFCODE('N','E','E'),"Northern Electric Equipment Joint Stock Company, Vietnam")\
X(NER,MANFCODE('N','E','R'),"Nero Electronics, Belarus")\
X(NES,MANFCODE('N','E','S'),"NORA ELK MALZ SAN ve TIC, Turkey")\
X(NET,MANFCODE('N','E','T'),"Netatmo, France")\
X(NGP,MANFCODE('N','G','P'),"Ngenic, Poland")\
X(NIK,MANFCODE('N','I','K'),"NIK ELEKTRONIKA, Ukraine")\
X(NIS,MANFCODE('N','I','S'),"Nisko Industries, Israel")\
X(NJC,MANFCODE('N','J','C'),"NAMJUN, South Korea")\
X(NKS,MANFCODE('N','K','S'),"N ERGIE Kundenservice, Germany")\
X(NLI,MANFCODE('N','L','I'),"Next Level Integration, Germany")\
X(NME,MANFCODE('N','M','E'),"SI ART, Russian Federation")\
X(NMG,MANFCODE('N','M','G'),"NMG, Poland")\
X(NMS,MANFCODE('N','M','S'),"Nisko Advanced Metering Solutions, Israel")\
X(NMT,MANFCODE('N','M','T'),"Nova met, Czech Republic")\
X(NNT,MANFCODE('N','N','T'),"2N Telekomunikace, Czech Republic")\
X(NOQ,MANFCODE('N','O','Q'),"NorthQ, Denmark")\
X(NOV,MANFCODE('N','O','V'),"NovaTech, United States of America")\
X(NPS,MANFCODE('N','P','S'),"NEOPIS, South Korea")\
X(NPT,MANFCODE('N','P','T'),"CJSC PROGTECH, Russian Federation")\
X(NRM,MANFCODE('N','R','M'),"Norm Elektronik, Turkey")\
X(NRN,MANFCODE('N','R','N'),"Neuron, Switzerland")\
X(NRT,MANFCODE('N','R','T'),"Zavod Nartis, Russian Federation")\
X(NSE,MANFCODE('N','S','E'),"North Smart Equipment, China")\
X(NSP,MANFCODE('N','S','P'),"M S N S Power, India")\
X(NTC,MANFCODE('N','T','C'),"Nuri Telecom, South Korea")\
X(NTM,MANFCODE('N','T','M'),"Netinium, Netherlands")\
X(NVD,MANFCODE('N','V','D'),"METER")\
X(NVN,MANFCODE('N','V','N'),"NOVEN ENERGY AND ICT, Turkey")\
X(NWG,MANFCODE('N','W','G'),"NINGBO WASSER GERAETE, China")\
X(NWM,MANFCODE('N','W','M'),"Ningbo Water Meter, China")\
X(NXG,MANFCODE('N','X','G'),"nexgen consultancy, India")\
X(NXP,MANFCODE('N','X','P'),"NXP Semiconductors, Netherlands")\
X(NYG,MANFCODE('N','Y','G'),"Ningbo Yonggang Instrument, China")\
X(NYN,MANFCODE('N','Y','N'),"Nanjing Yuneng Instrument, China")\
X(NZR,MANFCODE('N','Z','R'),"Nordwestdeutsche Zaehlerrevision Ing Aug Knemeyer, Germany")\
X(OAS,MANFCODE('O','A','S'),"Omni Agate Systems, India")\
X(OBC,MANFCODE('O','B','C'),"shandong oubiao information Technology, China")\
X(OBE,MANFCODE('O','B','E'),"Obeo, Norway")\
X(OBR,MANFCODE('O','B','R'),"RMZ OBRIY, Ukraine")\
X(ODI,MANFCODE('O','D','I'),"OAS Digital Infrastructures, India")\
X(ODK,MANFCODE('O','D','K'),"Okinawa Denki Kogyo, Japan")\
X(OEE,MANFCODE('O','E','E'),"ONUR Elektrik ve Elektronik, Turkey")\
X(OLI,MANFCODE('O','L','I'),"Olivetti, Italy")\
X(OMG,MANFCODE('O','M','G'),"Open Metering System Group OMS Group e V")\
X(OMS,MANFCODE('O','M','S'),"OMNISYSTEM, South Korea")\
X(ONR,MANFCODE('O','N','R'),"ONUR Elektroteknik, Turkey")\
X(ONS,MANFCODE('O','N','S'),"ONUR Elektroteknik, Turkey")\
X(OPT,MANFCODE('O','P','T'),"Optec, Switzerland")\
X(ORB,MANFCODE('O','R','B'),"ORBIS Tecnologia Electrica, Spain")\
X(ORM,MANFCODE('O','R','M'),"Ormazabal, Spain")\
X(OSA,MANFCODE('O','S','A'),"Osaki Electric Europe, Japan")\
X(OSK,MANFCODE('O','S','K'),"Osaki Electric, Japan")\
X(OTM,MANFCODE('O','T','M'),"OTMetric, France")\
X(OYK,MANFCODE('O','Y','K'),"GULLWING TIANJIN INDUSTRY DEVELOPMENGT, China")\
X(OZK,MANFCODE('O','Z','K'),"Oz kar Enerji, Turkey")\
X(PAD,MANFCODE('P','A','D'),"PadMess, Germany")\
X(PAF,MANFCODE('P','A','F'),"FAP PAFAL, Poland")\
X(PAK,MANFCODE('P','A','K'),"Paktim Energy Sp zo o, Poland")\
X(PAN,MANFCODE('P','A','N'),"Panasonic Corporation, Japan")\
X(PBR,MANFCODE('P','B','R'),"PFIFFNER do Brasil, Brazil")\
X(PCE,MANFCODE('P','C','E'),"Precise Electronics, Thailand")\
X(PCR,MANFCODE('P','C','R'),"Powercom, Israel")\
X(PDE,MANFCODE('P','D','E'),"Pfiffner Deutschland, Germany")\
X(PDX,MANFCODE('P','D','X'),"Paradox Engineering, Switzerland")\
X(PEA,MANFCODE('P','E','A'),"PEA J V Company, Ecuador")\
X(PEE,MANFCODE('P','E','E'),"Prantech Energy Solutions, India")\
X(PEL,MANFCODE('P','E','L'),"Pak Elektron PEL, Pakistan")\
X(PEP,MANFCODE('P','E','P'),"POWRTEC ENERGY, India")\
X(PER,MANFCODE('P','E','R'),"Perry Electric, Italy")\
X(PFI,MANFCODE('P','F','I'),"PFIFFNER Instrument Transformers, Switzerland")\
X(PGE,MANFCODE('P','G','E'),"PayGo Energy")\
X(PGP,MANFCODE('P','G','P'),"P G P Smart Sensing, Belgium")\
X(PHL,MANFCODE('P','H','L'),"HangZhou PAX Electronic Technology, China")\
X(PII,MANFCODE('P','I','I'),"PiiGAB Processinformation i Goteborg, Sweden")\
X(PIK,MANFCODE('P','I','K'),"pikkerton, Germany")\
X(PIL,MANFCODE('P','I','L'),"Pilot Systems London, United Kingdom")\
X(PIM,MANFCODE('P','I','M'),"Power Innovation, Germany")\
X(PIN,MANFCODE('P','I','N'),"PFIFFNER Instr Transformers, India")\
X(PIP,MANFCODE('P','I','P'),"Hermann Pipersberg jr, Germany")\
X(PIV,MANFCODE('P','I','V'),"Pivot Access, Rwanda")\
X(PLL,MANFCODE('P','L','L'),"POLL, Czech Republic")\
X(PLN,MANFCODE('P','L','N'),"Prolan Process Control Company, Hungary")\
X(PLO,MANFCODE('P','L','O'),"Weihai Ploumeter, China")\
X(PLU,MANFCODE('P','L','U'),"Plutus Smart Energy Solutions, India")\
X(PME,MANFCODE('P','M','E'),"Pal Mohan Electronics, India")\
X(PMG,MANFCODE('P','M','G'),"Sensus Metering Systems, Germany")\
X(PML,MANFCODE('P','M','L'),"PROGRESSIVE METERS, India")\
X(PMP,MANFCODE('P','M','P'),"REDUR, Germany")\
X(PMS,MANFCODE('P','M','S'),"PMS Elektronik, Germany")\
X(PMX,MANFCODE('P','M','X'),"Dell Anna Ing Luca, Italy")\
X(PNC,MANFCODE('P','N','C'),"PNC Technology, South Korea")\
X(POD,MANFCODE('P','O','D'),"PowerOneData, India")\
X(POL,MANFCODE('P','O','L'),"Pronal sp k, Poland")\
X(POW,MANFCODE('P','O','W'),"PowerApp, Denmark")\
X(POZ,MANFCODE('P','O','Z'),"ZEUP Pozyton, Poland")\
X(PPC,MANFCODE('P','P','C'),"Power Plus Communications, Germany")\
X(PPL,MANFCODE('P','P','L'),"Prompribor plant, Russian Federation")\
X(PPS,MANFCODE('P','P','S'),"Palace Power Systems, South Africa")\
X(PQP,MANFCODE('P','Q','P'),"PQ Plus, Germany")\
X(PRA,MANFCODE('P','R','A'),"Paya Ravesh Aria")\
X(PRE,MANFCODE('P','R','E'),"Predicate Software, South Africa")\
X(PRG,MANFCODE('P','R','G'),"Paud Raad Industrial Group, Iran")\
X(PRI,MANFCODE('P','R','I'),"Polymeters Response International")\
X(PRM,MANFCODE('P','R','M'),"Promatic, Croatia")\
X(PRO,MANFCODE('P','R','O'),"Proton Elektromed, Turkey")\
X(PRY,MANFCODE('P','R','Y'),"ShanDong LiChuang Science and Technology, China")\
X(PSE,MANFCODE('P','S','E'),"pSenso, Poland")\
X(PSN,MANFCODE('P','S','N'),"PySENSE, Poland")\
X(PST,MANFCODE('P','S','T'),"PSTec, South Korea")\
X(PTI,MANFCODE('P','T','I'),"Prolific Technology, Taiwan")\
X(PTR,MANFCODE('P','T','R'),"Pfiffner Transformatoer, Turkey")\
X(PUK,MANFCODE('P','U','K'),"Paktim Consulting UK, United Kingdom")\
X(PUL,MANFCODE('P','U','L'),"NPP Teplovodokhran")\
X(PVT,MANFCODE('P','V','T'),"Pavo Tasarim Uretim Elektronik Tic, Turkey")\
X(PWB,MANFCODE('P','W','B'),"Paul Wegener, Germany")\
X(PWR,MANFCODE('P','W','R'),"Powrtec, United States of America")\
X(PXC,MANFCODE('P','X','C'),"Phoenix Contact, Germany")\
X(PYU,MANFCODE('P','Y','U'),"PYUNGIL, South Korea")\
X(QDR,MANFCODE('Q','D','R'),"Quadrar Tecnologia, Brazil")\
X(QDS,MANFCODE('Q','D','S'),"Qundis, Germany")\
X(QFP,MANFCODE('Q','F','P'),"QFP Engineering, Italy")\
X(QSD,MANFCODE('Q','S','D'),"Quicksand, Belgium")\
X(QTS,MANFCODE('Q','T','S'),"QT systems, Sweden")\
X(RAC,MANFCODE('R','A','C'),"Michael Rac, Germany")\
X(RAD,MANFCODE('R','A','D'),"Radiocrafts, Norway")\
X(RAM,MANFCODE('R','A','M'),"Rossweiner Armaturen und Messgeraete OHG, Germany")\
X(RAS,MANFCODE('R','A','S'),"Rubikon Apskaitos Sistemos, Lithuania")\
X(RAY,MANFCODE('R','A','Y'),"Rayleigh Instruments, United Kingdom")\
X(RBM,MANFCODE('R','B','M'),"R B M, Italy")\
X(RCE,MANFCODE('R','C','E'),"RC ENERGY METERING, India")\
X(RDK,MANFCODE('R','D','K'),"Wuhan Radarking Electronics, China")\
X(RDM,MANFCODE('R','D','M'),"RDMx Consulting, Brazil")\
X(REC,MANFCODE('R','E','C'),"Zhejiang Reallin Electron, China")\
X(REF,MANFCODE('R','E','F'),"REFERANS ELEKTRIK SAYACLARI, Turkey")\
X(REI,MANFCODE('R','E','I'),"RENESAS ELECTRONICS, India")\
X(REL,MANFCODE('R','E','L'),"Relay, Germany")\
X(REM,MANFCODE('R','E','M'),"Remote Energy Monitoring, United Kingdom")\
X(REP,MANFCODE('R','E','P'),"Radiant Energy Solutions, India")\
X(RES,MANFCODE('R','E','S'),"Renesas Electronics, Singapore")\
X(RIC,MANFCODE('R','I','C'),"Richa Equipments, India")\
X(RIL,MANFCODE('R','I','L'),"Rikken Instrumentation, India")\
X(RIM,MANFCODE('R','I','M'),"CJSC Radio and Microelectronics, Russian Federation")\
X(RIN,MANFCODE('R','I','N'),"Rayleigh Instruments, United Kingdom")\
X(RIT,MANFCODE('R','I','T'),"Ritz Instrument Transformers, Germany")\
X(RIX,MANFCODE('R','I','X'),"Raonix, South Korea")\
X(RIZ,MANFCODE('R','I','Z'),"RIZ Transmitters, Croatia")\
X(RKE,MANFCODE('R','K','E'),"Viterra Energy Services formerly Raab Karcher ES")\
X(RMA,MANFCODE('R','M','A'),"Mess und Regeltechnik, Germany")\
X(RMG,MANFCODE('R','M','G'),"RMG Messtechnik, Germany")\
X(RML,MANFCODE('R','M','L'),"ROLEX METERS RPIVATE, India")\
X(RMR,MANFCODE('R','M','R'),"Advanced Technology RAMAR, United Kingdom")\
X(RMT,MANFCODE('R','M','T'),"Richter Messtechnik, Germany")\
X(RNW,MANFCODE('R','N','W'),"Renergy Micro Technologies, China")\
X(ROK,MANFCODE('R','O','K'),"ROKIP Liability Company, Russian Federation")\
X(RSA,MANFCODE('R','S','A'),"Rahrovan Sepehr Andisheh")\
X(RSM,MANFCODE('R','S','M'),"Zhejiang Risesun Science and Technology, China")\
X(RSW,MANFCODE('R','S','W'),"RSW Technik, Germany")\
X(SAA,MANFCODE('S','A','A'),"Sanjesh Afzar Asia, Iran")\
X(SAC,MANFCODE('S','A','C'),"Sacofgas, Italy")\
X(SAE,MANFCODE('S','A','E'),"SAE IT systems, Germany")\
X(SAG,MANFCODE('S','A','G'),"Sagemcom Energy Telecom, France")\
X(SAM,MANFCODE('S','A','M'),"Siemens OEsterreich AMIS Automated Metering and Information System, Austria")\
X(SAN,MANFCODE('S','A','N'),"SANN Stockholm, Sweden")\
X(SAP,MANFCODE('S','A','P'),"Sappel")\
X(SAT,MANFCODE('S','A','T'),"SATEC, Israel")\
X(SBC,MANFCODE('S','B','C'),"Saia Burgess Controls, Switzerland")\
X(SCA,MANFCODE('S','C','A'),"SENECA, Italy")\
X(SCE,MANFCODE('S','C','E'),"Seo Chang Electric Communication, South Korea")\
X(SCH,MANFCODE('S','C','H'),"Schinzel")\
X(SCL,MANFCODE('S','C','L'),"Steama Company")\
X(SCM,MANFCODE('S','C','M'),"CalinMeter, China")\
X(SCR,MANFCODE('S','C','R'),"Sanchuan Wisdom Technology, China")\
X(SCT,MANFCODE('S','C','T'),"S I C E Telecomunicazioni, Italy")\
X(SCW,MANFCODE('S','C','W'),"ScatterWeb, Germany")\
X(SDC,MANFCODE('S','D','C'),"SdC Sistemas de Contagem")\
X(SDM,MANFCODE('S','D','M'),"Shandong Delu Measurement, China")\
X(SDS,MANFCODE('S','D','S'),"Sitec Elettronica industriale, Italy")\
X(SEC,MANFCODE('S','E','C'),"Schneider Electric, Canada")\
X(SEE,MANFCODE('S','E','E'),"El Sewedy Electrometer, Egypt")\
X(SEH,MANFCODE('S','E','H'),"SAMRAKSHANA ELECTRICALS, India")\
X(SEI,MANFCODE('S','E','I'),"Sicom Electronics International, Chile")\
X(SEK,MANFCODE('S','E','K'),"StroyEnergoKom, Russian Federation")\
X(SEL,MANFCODE('S','E','L'),"Selec Controls, India")\
X(SEM,MANFCODE('S','E','M'),"Smart Meter Company, Myanmar")\
X(SEN,MANFCODE('S','E','N'),"Sensus Metering Systems, Germany")\
X(SEO,MANFCODE('S','E','O'),"SENSOCO Greatech, Germany")\
X(SET,MANFCODE('S','E','T'),"Sagemcom Energy Telecom, France")\
X(SFI,MANFCODE('S','F','I'),"Siemens Flow Instruments, Denmark")\
X(SFT,MANFCODE('S','F','T'),"Sotflink, Czech Republic")\
X(SGA,MANFCODE('S','G','A'),"smartGAS Mikrosensorik, Germany")\
X(SGM,MANFCODE('S','G','M'),"Swiss Gas Metering, Switzerland")\
X(SGN,MANFCODE('S','G','N'),"SYGNITY, Poland")\
X(SGX,MANFCODE('S','G','X'),"Gao Xiang Water Meter, China")\
X(SHD,MANFCODE('S','H','D'),"Beijing SanHuaDeBao Energy Technoligy, China")\
X(SHE,MANFCODE('S','H','E'),"Shenzhen SingHang Elec tech, China")\
X(SHM,MANFCODE('S','H','M'),"Shanghai Metering, China")\
X(SHT,MANFCODE('S','H','T'),"Shitek Technology, Italy")\
X(SIC,MANFCODE('S','I','C'),"SICK Engineering, Germany")\
X(SIE,MANFCODE('S','I','E'),"Siemens")\
X(SIG,MANFCODE('S','I','G'),"Sigrenea, France")\
X(SIJ,MANFCODE('S','I','J'),"SUN STAR INDUSTRIES, India")\
X(SIL,MANFCODE('S','I','L'),"Silicon Laboratories, United States of America")\
X(SIM,MANFCODE('S','I','M'),"Sana Intelligent Meter, Iran")\
X(SIN,MANFCODE('S','I','N'),"SINAPSI, Italy")\
X(SIS,MANFCODE('S','I','S'),"Sevme Informatique Service, France")\
X(SIT,MANFCODE('S','I','T'),"SITEL, Serbia")\
X(SIV,MANFCODE('S','I','V'),"Sieverding Heizungs und Sanitaertechnik, Germany")\
X(SIX,MANFCODE('S','I','X'),"Six Innovation, Sweden")\
X(SKI,MANFCODE('S','K','I'),"S K I, Germany")\
X(SKK,MANFCODE('S','K','K'),"Shikoku Instrumentation, Japan")\
X(SKN,MANFCODE('S','K','N'),"BENTEX CONTROL AND SWITCH GEAR, India")\
X(SKQ,MANFCODE('S','K','Q'),"SKI sherkate kontorsazi, Iran")\
X(SKT,MANFCODE('S','K','T'),"SkyToll, Slovakia")\
X(SKY,MANFCODE('S','K','Y'),"SKYLARK SMARTMETERS, India")\
X(SLB,MANFCODE('S','L','B'),"Schlumberger Industries, France")\
X(SLG,MANFCODE('S','L','G'),"Silergy Technologies")\
X(SLP,MANFCODE('S','L','P'),"Sylop spolka z ograniczona odpowiedzialnoscia sp k, Poland")\
X(SLV,MANFCODE('S','L','V'),"Solvimus, Germany")\
X(SLW,MANFCODE('S','L','W'),"SOLID WAY SAS, France")\
X(SLX,MANFCODE('S','L','X'),"Ymatron, Switzerland")\
X(SMA,MANFCODE('S','M','A'),"Smart me, Switzerland")\
X(SMC,MANFCODE('S','M','C'),"Sierra Monitor Corporation, United States of America")\
X(SME,MANFCODE('S','M','E'),"Siame, Tunisia")\
X(SMG,MANFCODE('S','M','G'),"Samgas, Italy")\
X(SMI,MANFCODE('S','M','I'),"PT SMART METER, Indonesia")\
X(SML,MANFCODE('S','M','L'),"Siemens Measurements")\
X(SMM,MANFCODE('S','M','M'),"Smart Metering, Italy")\
X(SMN,MANFCODE('S','M','N'),"Saiman Corporation, Kazakhstan")\
X(SMP,MANFCODE('S','M','P'),"LLC FIRM SEMPAL, Ukraine")\
X(SMQ,MANFCODE('S','M','Q'),"SMARTMETERQ, Italy")\
X(SMR,MANFCODE('S','M','R'),"Saudi Meters Company, Saudi Arabia")\
X(SMS,MANFCODE('S','M','S'),"Smart Metering Solutions Changsha, China")\
X(SMT,MANFCODE('S','M','T'),"Smarteh, Slovenia")\
X(SMX,MANFCODE('S','M','X'),"Smart Meters Technologies Sdn Bhd, Malaysia")\
X(SNB,MANFCODE('S','N','B'),"Stromnetz Berlin, Germany")\
X(SNM,MANFCODE('S','N','M'),"ShenZhen Northmeter, China")\
X(SNR,MANFCODE('S','N','R'),"NTN SNR, France")\
X(SNS,MANFCODE('S','N','S'),"Signals and Systems, India")\
X(SNT,MANFCODE('S','N','T'),"SensorNet, Italy")\
X(SOC,MANFCODE('S','O','C'),"SOCOMEC, France")\
X(SOF,MANFCODE('S','O','F'),"Softflow de, Germany")\
X(SOG,MANFCODE('S','O','G'),"Sogecam Industrial, Spain")\
X(SOL,MANFCODE('S','O','L'),"Soledia, Italy")\
X(SOM,MANFCODE('S','O','M'),"Somesca, France")\
X(SON,MANFCODE('S','O','N'),"Sontex, Switzerland")\
X(SOS,MANFCODE('S','O','S'),"SOFTSERVICE, Ukraine")\
X(SOT,MANFCODE('S','O','T'),"Sotronix, Germany")\
X(SPC,MANFCODE('S','P','C'),"JSC RPC Spektr, Russian Federation")\
X(SPE,MANFCODE('S','P','E'),"SUKHILA POWER ELECTRONICS, India")\
X(SPL,MANFCODE('S','P','L'),"Sappel")\
X(SPM,MANFCODE('S','P','M'),"Stelmec Powercom, India")\
X(SPX,MANFCODE('S','P','X'),"Sensus Metering Systems, Germany")\
X(SPZ,MANFCODE('S','P','Z'),"SPowerZ Solutions, India")\
X(SRE,MANFCODE('S','R','E'),"Guangzhou Sunrise Electronics Development, China")\
X(SRF,MANFCODE('S','R','F'),"Saraf Industries, India")\
X(SRN,MANFCODE('S','R','N'),"Shandong SARON Intelligent Technology, China")\
X(SRV,MANFCODE('S','R','V'),"Servic, Ukraine")\
X(SSE,MANFCODE('S','S','E'),"S T Smart Energy, Austria")\
X(SSG,MANFCODE('S','S','G'),"Super Star Electronics, Bangladesh")\
X(SSI,MANFCODE('S','S','I'),"Security Solutions Institute, Bulgaria")\
X(SSL,MANFCODE('S','S','L'),"Synapsys Solutions")\
X(SSM,MANFCODE('S','S','M'),"SCC METERS, Bangladesh")\
X(SSN,MANFCODE('S','S','N'),"Silver Spring Networks, United States of America")\
X(SSS,MANFCODE('S','S','S'),"SUEZ SMART SOLUTIONS, France")\
X(SST,MANFCODE('S','S','T'),"Qingdao Haina Electric Automation Systems, China")\
X(STA,MANFCODE('S','T','A'),"Shenzhen Star Instrument, China")\
X(STC,MANFCODE('S','T','C'),"Sunrise Technology, China")\
X(STD,MANFCODE('S','T','D'),"Stedin, Netherlands")\
X(STE,MANFCODE('S','T','E'),"Satera Elektrik Elektronik San ve Tic")\
X(STF,MANFCODE('S','T','F'),"STACKFORCE, Germany")\
X(STL,MANFCODE('S','T','L'),"Saudi Technical Group, Saudi Arabia")\
X(STM,MANFCODE('S','T','M'),"STELMEC, India")\
X(STO,MANFCODE('S','T','O'),"ABB STOTZ KONTAKT, Germany")\
X(STR,MANFCODE('S','T','R'),"Strike Technologies, South Africa")\
X(STS,MANFCODE('S','T','S'),"Swistec Systems, Switzerland")\
X(STV,MANFCODE('S','T','V'),"STV Automation Branch of STV Electronic, Germany")\
X(STZ,MANFCODE('S','T','Z'),"Steinbeis Innovation Center Embedded Design and Networking, Germany")\
X(SUN,MANFCODE('S','U','N'),"TIAN JIN SUN ENERGY TECHNOLOGY, China")\
X(SVM,MANFCODE('S','V','M'),"AB Svensk Vaermemaetning SVM")\
X(SVT,MANFCODE('S','V','T'),"SPUTNIK, Russian Federation")\
X(SWI,MANFCODE('S','W','I'),"Swistec, Germany")\
X(SWM,MANFCODE('S','W','M'),"Smart Water Metering, Canada")\
X(SWS,MANFCODE('S','W','S'),"Stadtwerke Senftenberg, Germany")\
X(SWT,MANFCODE('S','W','T'),"Beijing Swirling Technology, China")\
X(SYC,MANFCODE('S','Y','C'),"Sycous Leeds Innovation Centre, United Kingdom")\
X(SYN,MANFCODE('S','Y','N'),"SMSISTEM, Turkey")\
X(SYS,MANFCODE('S','Y','S'),"Softwareentwicklung Systemdesign, Austria")\
X(SYX,MANFCODE('S','Y','X'),"SyxthSense, United Kingdom")\
X(SZS,MANFCODE('S','Z','S'),"Szerver Szektor Kft, Hungary")\
X(TAG,MANFCODE('T','A','G'),"Telma, Switzerland")\
X(TAL,MANFCODE('T','A','L'),"TALAMONA, Italy")\
X(TAN,MANFCODE('T','A','N'),"Tianxin instrument group, China")\
X(TAS,MANFCODE('T','A','S'),"Pouyeshgaran Tabriz Azma, Iran")\
X(TAT,MANFCODE('T','A','T'),"Tatung, Taiwan")\
X(TAY,MANFCODE('T','A','Y'),"Taytech Otomasyon ve Bilisim Teknolojileri Sti, Turkey")\
X(TAZ,MANFCODE('T','A','Z'),"PoyeshGaran Sahandzaran Tabrizazma, Iran")\
X(TBN,MANFCODE('T','B','N'),"TBEA Nanjing Intelligent Electric, China")\
X(TBS,MANFCODE('T','B','S'),"TEBAS END ISI SIS INS TUR SAN VE TIC STI, Turkey")\
X(TCE,MANFCODE('T','C','E'),"Qingdao iTechene Technologies, China")\
X(TCH,MANFCODE('T','C','H'),"Techem Service")\
X(TCM,MANFCODE('T','C','M'),"TCOM, Serbia")\
X(TCO,MANFCODE('T','C','O'),"Teco, Czech Republic")\
X(TCP,MANFCODE('T','C','P'),"Telecard Prilad, Ukraine")\
X(TCT,MANFCODE('T','C','T'),"Tecnotel, Italy")\
X(TCX,MANFCODE('T','C','X'),"Qingdao Topscomm Communication, China")\
X(TCZ,MANFCODE('T','C','Z'),"Tianjin Chuangzhan Tongcheng Technology Development, China")\
X(TDC,MANFCODE('T','D','C'),"Telecom Design, France")\
X(TEA,MANFCODE('T','E','A'),"TEAM R")\
X(TEC,MANFCODE('T','E','C'),"TECSON Digital, Germany")\
X(TEH,MANFCODE('T','E','H'),"IOTech")\
X(TEI,MANFCODE('T','E','I'),"Tohoku Electric Meter Industry, Japan")\
X(TEK,MANFCODE('T','E','K'),"Tekmar Regelsysteme, Germany")\
X(TEN,MANFCODE('T','E','N'),"TekhnoEnergo, Russian Federation")\
X(TEO,MANFCODE('T','E','O'),"ubitricity Gesellschaft fur verteilte Energiesysteme mbH, Germany")\
X(TEP,MANFCODE('T','E','P'),"TEPEECAL, France")\
X(TEU,MANFCODE('T','E','U'),"TOSHELECTROAPPARAT FE, Uzbekistan")\
X(TFC,MANFCODE('T','F','C'),"Toos Fuse, Iran")\
X(TFG,MANFCODE('T','F','G'),"TERMICS Divisione FIMIGAS, Italy")\
X(TGX,MANFCODE('T','G','X'),"Tiesse, Italy")\
X(THE,MANFCODE('T','H','E'),"Theben, Germany")\
X(THW,MANFCODE('T','H','W'),"TW TEAMWARE, Italy")\
X(TIC,MANFCODE('T','I','C'),"TOKYO KEISO, Japan")\
X(TID,MANFCODE('T','I','D'),"TIDE, South Korea")\
X(TIG,MANFCODE('T','I','G'),"ZHONGHUAN TIG, China")\
X(TII,MANFCODE('T','I','I'),"TRIKALA INDUSTRIES, India")\
X(TIL,MANFCODE('T','I','L'),"Thermal Integration, United Kingdom")\
X(TIP,MANFCODE('T','I','P'),"TIP, Germany")\
X(TIS,MANFCODE('T','I','S'),"Texas Instruments, Hong Kong")\
X(TIX,MANFCODE('T','I','X'),"Tixi Com")\
X(TKN,MANFCODE('T','K','N'),"TECHKNAVE, India")\
X(TKS,MANFCODE('T','K','S'),"Teksan Teknolojik OElcum Sistemleri, Turkey")\
X(TLC,MANFCODE('T','L','C'),"TELECON GALICIA, Spain")\
X(TLM,MANFCODE('T','L','M'),"Theodor Lange Messgeraete, Germany")\
X(TLR,MANFCODE('T','L','R'),"Telereading, Italy")\
X(TLS,MANFCODE('T','L','S'),"TLS Energimaetning, Sweden")\
X(TLT,MANFCODE('T','L','T'),"Telecommunication Technologies, Ukraine")\
X(TLY,MANFCODE('T','L','Y'),"LLC SPE Telemetry, Ukraine")\
X(TME,MANFCODE('T','M','E'),"TECHNO METERS ELECTRONICS, India")\
X(TMK,MANFCODE('T','M','K'),"Timi Kosova Sh p k")\
X(TMS,MANFCODE('T','M','S'),"TEMASS IMALAT, Turkey")\
X(TMZ,MANFCODE('T','M','Z'),"TMZ Thuringer Mess und Zaehlerwesen Service, Germany")\
X(TOP,MANFCODE('T','O','P'),"KMB systems, Czech Republic")\
X(TPB,MANFCODE('T','P','B'),"2 Plus AD, Bulgaria")\
X(TPC,MANFCODE('T','P','C'),"Taipit measuring equipment, Russian Federation")\
X(TPI,MANFCODE('T','P','I'),"Transfopower Industries, Pakistan")\
X(TPJ,MANFCODE('T','P','J'),"TAKAHATA PRECISION, Japan")\
X(TPL,MANFCODE('T','P','L'),"Teplocom Holding, Russian Federation")\
X(TPZ,MANFCODE('T','P','Z'),"PLC Technology")\
X(TRC,MANFCODE('T','R','C'),"Traco Doo, Serbia")\
X(TRG,MANFCODE('T','R','G'),"Trench, Germany")\
X(TRI,MANFCODE('T','R','I'),"Tritech Technology, Sweden")\
X(TRJ,MANFCODE('T','R','J'),"SHENZHEN TECHRISE ELECTRONICS, China")\
X(TRL,MANFCODE('T','R','L'),"Trilliant, Canada")\
X(TRN,MANFCODE('T','R','N'),"TERRANOVA, Italy")\
X(TRO,MANFCODE('T','R','O'),"TROX, Germany")\
X(TRU,MANFCODE('T','R','U'),"Truteq Wireless, South Africa")\
X(TRV,MANFCODE('T','R','V'),"Transvaro Elektron Aletleri, Turkey")\
X(TRW,MANFCODE('T','R','W'),"Triowatt")\
X(TRX,MANFCODE('T','R','X'),"Beijing TianRuiXiang Equipment, China")\
X(TRZ,MANFCODE('T','R','Z'),"TR Group, South Africa")\
X(TSD,MANFCODE('T','S','D'),"Theobroma Systems Design und Consulting, Austria")\
X(TSE,MANFCODE('T','S','E'),"Nichi Manufacturing, India")\
X(TSG,MANFCODE('T','S','G'),"Testo Sensor, Germany")\
X(TTM,MANFCODE('T','T','M'),"Toshiba Toko Meter Systems, Japan")\
X(TTR,MANFCODE('T','T','R'),"Tetraedre, Switzerland")\
X(TTT,MANFCODE('T','T','T'),"Telephone and Telegraph Technique, Bulgaria")\
X(TUR,MANFCODE('T','U','R'),"TURKSAY ELEKTRONIK ELEKTRIK ENDUSTRISI")\
X(TWO,MANFCODE('T','W','O'),"2Flow, Sweden")\
X(TXL,MANFCODE('T','X','L'),"CETC46 TianJin New Top Electronics Technology, China")\
X(UAG,MANFCODE('U','A','G'),"Uher")\
X(UBI,MANFCODE('U','B','I'),"Ubitronix system solutions, Austria")\
X(UBY,MANFCODE('U','B','Y'),"ubitricity Gesellschaft fur verteilte Energiesysteme mbH, Germany")\
X(UEI,MANFCODE('U','E','I'),"United Electrical Industries, India")\
X(UEL,MANFCODE('U','E','L'),"united electrical industries, India")\
X(UGI,MANFCODE('U','G','I'),"United Gas Industries")\
X(UGT,MANFCODE('U','G','T'),"DP UKRGAZTECH Ukrainian gas technologies, Ukraine")\
X(UHM,MANFCODE('U','H','M'),"Micronics, United Kingdom")\
X(UNE,MANFCODE('U','N','E'),"Zhejiang Goldcard Power Tech, China")\
X(UNI,MANFCODE('U','N','I'),"Univations, Hong Kong")\
X(URM,MANFCODE('U','R','M'),"Urmet Telecomunicazioni, Italy")\
X(USC,MANFCODE('U','S','C'),"Usanca Soluciones, Spain")\
X(UTF,MANFCODE('U','T','F'),"UtiliFlex, United States of America")\
X(UTI,MANFCODE('U','T','I'),"Utilia, Italy")\
X(UTL,MANFCODE('U','T','L'),"United Telecoms, India")\
X(UTT,MANFCODE('U','T','T'),"UtiliTools, Germany")\
X(VAL,MANFCODE('V','A','L'),"Valkoder, Bulgaria")\
X(VDP,MANFCODE('V','D','P'),"Plant Vodopribor management company, Russian Federation")\
X(VEC,MANFCODE('V','E','C'),"Energo Control, Ukraine")\
X(VEL,MANFCODE('V','E','L'),"VELANKANI ELECTRONICS, India")\
X(VER,MANFCODE('V','E','R'),"VERAUT, Austria")\
X(VES,MANFCODE('V','E','S'),"Viterra Energy Services")\
X(VGO,MANFCODE('V','G','O'),"Vango Technologies, Taiwan")\
X(VIE,MANFCODE('V','I','E'),"Vientech, France")\
X(VIK,MANFCODE('V','I','K'),"VI KO ELEKTRIK, Turkey")\
X(VIM,MANFCODE('V','I','M'),"VIEN ENERJI SISTEMLERI SANAYI VE TICARET SIRKETI, Turkey")\
X(VIN,MANFCODE('V','I','N'),"Vektor innovations, India")\
X(VIP,MANFCODE('V','I','P'),"VIPA CZ, Czech Republic")\
X(VIT,MANFCODE('V','I','T'),"Vitir, Norway")\
X(VLT,MANFCODE('V','L','T'),"ABB EPMV Division, Czech Republic")\
X(VMP,MANFCODE('V','M','P'),"VAMP, Finland")\
X(VNE,MANFCODE('V','N','E'),"Vision Networks, India")\
X(VPI,MANFCODE('V','P','I'),"Van Putten Instruments")\
X(VPL,MANFCODE('V','P','L'),"Verticross, India")\
X(VSE,MANFCODE('V','S','E'),"Valenciana Smart Energy of Mediterranean Sea, Spain")\
X(VSN,MANFCODE('V','S','N'),"Viewshine, China")\
X(VTC,MANFCODE('V','T','C'),"Vitelec, Netherlands")\
X(VTG,MANFCODE('V','T','G'),"vemm tec Messtechnik")\
X(VTK,MANFCODE('V','T','K'),"Linkwell Telesystems, India")\
X(VTN,MANFCODE('V','T','N'),"VITEX NOVA, Ukraine")\
X(VTZ,MANFCODE('V','T','Z'),"VitzroSys, South Korea")\
X(VVV,MANFCODE('V','V','V'),"VIVAVIS, Germany")\
X(WAD,MANFCODE('W','A','D'),"Waher Data, Sweden")\
X(WAH,MANFCODE('W','A','H'),"WAHESOFT, Germany")\
X(WAI,MANFCODE('W','A','I'),"Chongqing WECAN Precision Instruments, China")\
X(WAL,MANFCODE('W','A','L'),"Wallaby Metering Systems, India")\
X(WDN,MANFCODE('W','D','N'),"Webdyn, France")\
X(WEB,MANFCODE('W','E','B'),"Webolution, Germany")\
X(WEG,MANFCODE('W','E','G'),"WEG Equipamentos Eletricos Automacao, Brazil")\
X(WEH,MANFCODE('W','E','H'),"E Wehrle, Germany")\
X(WEL,MANFCODE('W','E','L'),"WELLTECH automation, China")\
X(WEP,MANFCODE('W','E','P'),"Weptech elektronik, Germany")\
X(WFT,MANFCODE('W','F','T'),"Waft Embedded Circuit Solutions, India")\
X(WGN,MANFCODE('W','G','N'),"Wasser Geraete, Germany")\
X(WGP,MANFCODE('W','G','P'),"GreenPoint, Poland")\
X(WIG,MANFCODE('W','I','G'),"Wigersma Sikkema, Netherlands")\
X(WIK,MANFCODE('W','I','K'),"WIKON Kommunikationstechnik, Germany")\
X(WIN,MANFCODE('W','I','N'),"Windmill Innovations, Netherlands")\
X(WKL,MANFCODE('W','K','L'),"Shenyang jia DE lian yi energy technology, China")\
X(WKX,MANFCODE('W','K','X'),"JINING WUKEXING METER, China")\
X(WMO,MANFCODE('W','M','O'),"Westermo Teleindustri, Sweden")\
X(WNC,MANFCODE('W','N','C'),"wireless netcontrol, Germany")\
X(WNW,MANFCODE('W','N','W'),"Wistron NeWeb Corporation Marketing Center, Taiwan")\
X(WOW,MANFCODE('W','O','W'),"Sciknow Techno Solutions, India")\
X(WSD,MANFCODE('W','S','D'),"Yantai Wisdom Electric, China")\
X(WSE,MANFCODE('W','S','E'),"Wasion Group, China")\
X(WSG,MANFCODE('W','S','G'),"ZHEJIANG WELLSUN INTELLIGENT TECHNOLOGY, China")\
X(WSM,MANFCODE('W','S','M'),"winAMR Systems, India")\
X(WSR,MANFCODE('W','S','R'),"WESER, Russian Federation")\
X(WTI,MANFCODE('W','T','I'),"Weihai Sunts Electric Meter, China")\
X(WTL,MANFCODE('W','T','L'),"Wipro Technologies, India")\
X(WTM,MANFCODE('W','T','M'),"Watertech, Italy")\
X(WTT,MANFCODE('W','T','T'),"Watertech, Italy")\
X(WUR,MANFCODE('W','U','R'),"Wurm Elektronische Systeme, Germany")\
X(WZG,MANFCODE('W','Z','G'),"Neumann Wasserzaehler Glaubitz, Germany")\
X(WZT,MANFCODE('W','Z','T'),"Wizit, South Korea")\
X(XAO,MANFCODE('X','A','O'),"Info Solution, Italy")\
X(XEM,MANFCODE('X','E','M'),"XEMTEC, Switzerland")\
X(XIO,MANFCODE('X','I','O'),"XIOTA, India")\
X(XJM,MANFCODE('X','J','M'),"XJ Metering, China")\
X(XMA,MANFCODE('X','M','A'),"XMASTER, Poland")\
X(XMX,MANFCODE('X','M','X'),"Xemex, Belgium")\
X(XTM,MANFCODE('X','T','M'),"Suntront Tech, China")\
X(XTR,MANFCODE('X','T','R'),"HENAN SUNTRONT TECH, China")\
X(XTY,MANFCODE('X','T','Y'),"LianYuanGang Tengyue Electronics Technology")\
X(YDD,MANFCODE('Y','D','D'),"Jilin Yongda Group")\
X(YDS,MANFCODE('Y','D','S'),"YIDU Smart Technology Beijing, China")\
X(YFC,MANFCODE('Y','F','C'),"Yufeng Changhui Automation Instrument, China")\
X(YGM,MANFCODE('Y','G','M'),"YGM Shandong Yiguang heat metering technology, China")\
X(YHE,MANFCODE('Y','H','E'),"Youho Electric, South Korea")\
X(YJZ,MANFCODE('Y','J','Z'),"Zhuhai Yujian Science Technology, China")\
X(YNP,MANFCODE('Y','N','P'),"Ningbo Yong Neng Power Technology, China")\
X(YPP,MANFCODE('Y','P','P'),"YPP, South Korea")\
X(YSS,MANFCODE('Y','S','S'),"Yellowstone Soft, Germany")\
X(YTE,MANFCODE('Y','T','E'),"Yuksek Teknoloji, Turkey")\
X(YTL,MANFCODE('Y','T','L'),"ZheJiang yongtailong electronic, China")\
X(YYW,MANFCODE('Y','Y','W'),"Shandong youyuan instrument, China")\
X(YZR,MANFCODE('Y','Z','R'),"Cangzhou City Hebei Electronic Technology, China")\
X(ZAG,MANFCODE('Z','A','G'),"Zellweger Uster, Switzerland")\
X(ZAP,MANFCODE('Z','A','P'),"Zaptronix")\
X(ZAR,MANFCODE('Z','A','R'),"SNC ZARALAB, Bulgaria")\
X(ZCH,MANFCODE('Z','C','H'),"Zhejiang Chaorong Electric Technology, China")\
X(ZEL,MANFCODE('Z','E','L'),"Dr techn Josef Zelisko, Austria")\
X(ZEN,MANFCODE('Z','E','N'),"ZenMeter Solutions, India")\
X(ZEX,MANFCODE('Z','E','X'),"ZEXON ENERGY, India")\
X(ZFY,MANFCODE('Z','F','Y'),"Hang Zhou Fu Yang Instrument General Factory, China")\
X(ZGX,MANFCODE('Z','G','X'),"ZIGNUX TECHNOLOGY, Spain")\
X(ZIP,MANFCODE('Z','I','P'),"St Petersburg Meters Factory, Russian Federation")\
X(ZIV,MANFCODE('Z','I','V'),"ZIV Aplicaciones y Tecnologia")\
X(ZJY,MANFCODE('Z','J','Y'),"Zhejiang Jiayou Thermal Technology Equipment, China")\
X(ZOT,MANFCODE('Z','O','T'),"Zhejiang Ocaenergy Technology")\
X(ZPA,MANFCODE('Z','P','A'),"ZPA Smart Energy, Czech Republic")\
X(ZRI,MANFCODE('Z','R','I'),"ZENNER International, Germany")\
X(ZRM,MANFCODE('Z','R','M'),"ZENNER International, Germany")\
X(ZTE,MANFCODE('Z','T','E'),"ZTE Corporation ZTE Plaza, China")\
X(ZTX,MANFCODE('Z','T','X'),"ZHEJIANG TANCY INSTRUMENT TECHNOLOGY eTD, China")\
X(ZTY,MANFCODE('Z','T','Y'),"ZHEJIANG CHINT INSTRUMENT METER, China")\
X(ZVC,MANFCODE('Z','V','C'),"SigmaHeat")\
X(ZXT,MANFCODE('Z','X','T'),"Zhejiang Xinghao Technology")\
X(ZXY,MANFCODE('Z','X','Y'),"Linyi City Xiaoyuan Water Meter, China")\
X(ZYB,MANFCODE('Z','Y','B'),"WEIHAI ZHENYU INTELL TECH, China")\
X(ZZZ,MANFCODE('Z','Z','Z'),"Michael Rac, Germany")\

#define MANUFACTURER_AAA MANFCODE('A','A','A')
#define MANUFACTURER_AAB MANFCODE('A','A','B')
#define MANUFACTURER_ABB MANFCODE('A','B','B')
#define MANUFACTURER_ABC MANFCODE('A','B','C')
#define MANUFACTURER_ABN MANFCODE('A','B','N')
#define MANUFACTURER_ABR MANFCODE('A','B','R')
#define MANUFACTURER_ACA MANFCODE('A','C','A')
#define MANUFACTURER_ACB MANFCODE('A','C','B')
#define MANUFACTURER_ACC MANFCODE('A','C','C')
#define MANUFACTURER_ACE MANFCODE('A','C','E')
#define MANUFACTURER_ACG MANFCODE('A','C','G')
#define MANUFACTURER_ACH MANFCODE('A','C','H')
#define MANUFACTURER_ACL MANFCODE('A','C','L')
#define MANUFACTURER_ACN MANFCODE('A','C','N')
#define MANUFACTURER_ACS MANFCODE('A','C','S')
#define MANUFACTURER_ACT MANFCODE('A','C','T')
#define MANUFACTURER_ACW MANFCODE('A','C','W')
#define MANUFACTURER_ADA MANFCODE('A','D','A')
#define MANUFACTURER_ADD MANFCODE('A','D','D')
#define MANUFACTURER_ADE MANFCODE('A','D','E')
#define MANUFACTURER_ADF MANFCODE('A','D','F')
#define MANUFACTURER_ADN MANFCODE('A','D','N')
#define MANUFACTURER_ADR MANFCODE('A','D','R')
#define MANUFACTURER_ADU MANFCODE('A','D','U')
#define MANUFACTURER_ADV MANFCODE('A','D','V')
#define MANUFACTURER_ADX MANFCODE('A','D','X')
#define MANUFACTURER_AEA MANFCODE('A','E','A')
#define MANUFACTURER_AEC MANFCODE('A','E','C')
#define MANUFACTURER_AEE MANFCODE('A','E','E')
#define MANUFACTURER_AEG MANFCODE('A','E','G')
#define MANUFACTURER_AEI MANFCODE('A','E','I')
#define MANUFACTURER_AEL MANFCODE('A','E','L')
#define MANUFACTURER_AEM MANFCODE('A','E','M')
#define MANUFACTURER_AER MANFCODE('A','E','R')
#define MANUFACTURER_AES MANFCODE('A','E','S')
#define MANUFACTURER_AFX MANFCODE('A','F','X')
#define MANUFACTURER_AGE MANFCODE('A','G','E')
#define MANUFACTURER_AGT MANFCODE('A','G','T')
#define MANUFACTURER_AHV MANFCODE('A','H','V')
#define MANUFACTURER_AHX MANFCODE('A','H','X')
#define MANUFACTURER_AIC MANFCODE('A','I','C')
#define MANUFACTURER_AIM MANFCODE('A','I','M')
#define MANUFACTURER_ALC MANFCODE('A','L','C')
#define MANUFACTURER_ALF MANFCODE('A','L','F')
#define MANUFACTURER_ALG MANFCODE('A','L','G')
#define MANUFACTURER_ALH MANFCODE('A','L','H')
#define MANUFACTURER_ALK MANFCODE('A','L','K')
#define MANUFACTURER_ALL MANFCODE('A','L','L')
#define MANUFACTURER_ALP MANFCODE('A','L','P')
#define MANUFACTURER_ALR MANFCODE('A','L','R')
#define MANUFACTURER_ALT MANFCODE('A','L','T')
#define MANUFACTURER_ALV MANFCODE('A','L','V')
#define MANUFACTURER_AMB MANFCODE('A','M','B')
#define MANUFACTURER_AMC MANFCODE('A','M','C')
#define MANUFACTURER_AMD MANFCODE('A','M','D')
#define MANUFACTURER_AME MANFCODE('A','M','E')
#define MANUFACTURER_AMG MANFCODE('A','M','G')
#define MANUFACTURER_AMH MANFCODE('A','M','H')
#define MANUFACTURER_AMI MANFCODE('A','M','I')
#define MANUFACTURER_AML MANFCODE('A','M','L')
#define MANUFACTURER_AMP MANFCODE('A','M','P')
#define MANUFACTURER_AMR MANFCODE('A','M','R')
#define MANUFACTURER_AMS MANFCODE('A','M','S')
#define MANUFACTURER_AMT MANFCODE('A','M','T')
#define MANUFACTURER_AMX MANFCODE('A','M','X')
#define MANUFACTURER_ANA MANFCODE('A','N','A')
#define MANUFACTURER_AND MANFCODE('A','N','D')
#define MANUFACTURER_ANZ MANFCODE('A','N','Z')
#define MANUFACTURER_AOM MANFCODE('A','O','M')
#define MANUFACTURER_AON MANFCODE('A','O','N')
#define MANUFACTURER_APA MANFCODE('A','P','A')
#define MANUFACTURER_APL MANFCODE('A','P','L')
#define MANUFACTURER_APO MANFCODE('A','P','O')
#define MANUFACTURER_APR MANFCODE('A','P','R')
#define MANUFACTURER_APS MANFCODE('A','P','S')
#define MANUFACTURER_APT MANFCODE('A','P','T')
#define MANUFACTURER_APX MANFCODE('A','P','X')
#define MANUFACTURER_AQA MANFCODE('A','Q','A')
#define MANUFACTURER_AQL MANFCODE('A','Q','L')
#define MANUFACTURER_AQM MANFCODE('A','Q','M')
#define MANUFACTURER_AQT MANFCODE('A','Q','T')
#define MANUFACTURER_AQU MANFCODE('A','Q','U')
#define MANUFACTURER_ARA MANFCODE('A','R','A')
#define MANUFACTURER_ARC MANFCODE('A','R','C')
#define MANUFACTURER_ARD MANFCODE('A','R','D')
#define MANUFACTURER_ARF MANFCODE('A','R','F')
#define MANUFACTURER_ARG MANFCODE('A','R','G')
#define MANUFACTURER_ARK MANFCODE('A','R','K')
#define MANUFACTURER_ARM MANFCODE('A','R','M')
#define MANUFACTURER_ARS MANFCODE('A','R','S')
#define MANUFACTURER_ART MANFCODE('A','R','T')
#define MANUFACTURER_ARW MANFCODE('A','R','W')
#define MANUFACTURER_ASA MANFCODE('A','S','A')
#define MANUFACTURER_ASC MANFCODE('A','S','C')
#define MANUFACTURER_ASD MANFCODE('A','S','D')
#define MANUFACTURER_ASG MANFCODE('A','S','G')
#define MANUFACTURER_ASH MANFCODE('A','S','H')
#define MANUFACTURER_ASJ MANFCODE('A','S','J')
#define MANUFACTURER_ASM MANFCODE('A','S','M')
#define MANUFACTURER_ASR MANFCODE('A','S','R')
#define MANUFACTURER_AST MANFCODE('A','S','T')
#define MANUFACTURER_ATF MANFCODE('A','T','F')
#define MANUFACTURER_ATI MANFCODE('A','T','I')
#define MANUFACTURER_ATL MANFCODE('A','T','L')
#define MANUFACTURER_ATM MANFCODE('A','T','M')
#define MANUFACTURER_ATS MANFCODE('A','T','S')
#define MANUFACTURER_AUR MANFCODE('A','U','R')
#define MANUFACTURER_AUT MANFCODE('A','U','T')
#define MANUFACTURER_AUX MANFCODE('A','U','X')
#define MANUFACTURER_AVA MANFCODE('A','V','A')
#define MANUFACTURER_AXI MANFCODE('A','X','I')
#define MANUFACTURER_AXS MANFCODE('A','X','S')
#define MANUFACTURER_AYS MANFCODE('A','Y','S')
#define MANUFACTURER_AZE MANFCODE('A','Z','E')
#define MANUFACTURER_BAM MANFCODE('B','A','M')
#define MANUFACTURER_BAR MANFCODE('B','A','R')
#define MANUFACTURER_BAS MANFCODE('B','A','S')
#define MANUFACTURER_BBE MANFCODE('B','B','E')
#define MANUFACTURER_BBS MANFCODE('B','B','S')
#define MANUFACTURER_BCE MANFCODE('B','C','E')
#define MANUFACTURER_BCR MANFCODE('B','C','R')
#define MANUFACTURER_BEA MANFCODE('B','E','A')
#define MANUFACTURER_BEE MANFCODE('B','E','E')
#define MANUFACTURER_BEF MANFCODE('B','E','F')
#define MANUFACTURER_BEG MANFCODE('B','E','G')
#define MANUFACTURER_BEL MANFCODE('B','E','L')
#define MANUFACTURER_BEN MANFCODE('B','E','N')
#define MANUFACTURER_BER MANFCODE('B','E','R')
#define MANUFACTURER_BFW MANFCODE('B','F','W')
#define MANUFACTURER_BHG MANFCODE('B','H','G')
#define MANUFACTURER_BJY MANFCODE('B','J','Y')
#define MANUFACTURER_BKB MANFCODE('B','K','B')
#define MANUFACTURER_BKO MANFCODE('B','K','O')
#define MANUFACTURER_BKT MANFCODE('B','K','T')
#define MANUFACTURER_BLM MANFCODE('B','L','M')
#define MANUFACTURER_BLU MANFCODE('B','L','U')
#define MANUFACTURER_BME MANFCODE('B','M','E')
#define MANUFACTURER_BMI MANFCODE('B','M','I')
#define MANUFACTURER_BMP MANFCODE('B','M','P')
#define MANUFACTURER_BMT MANFCODE('B','M','T')
#define MANUFACTURER_BNR MANFCODE('B','N','R')
#define MANUFACTURER_BOV MANFCODE('B','O','V')
#define MANUFACTURER_BPM MANFCODE('B','P','M')
#define MANUFACTURER_BRA MANFCODE('B','R','A')
#define MANUFACTURER_BRN MANFCODE('B','R','N')
#define MANUFACTURER_BRT MANFCODE('B','R','T')
#define MANUFACTURER_BSC MANFCODE('B','S','C')
#define MANUFACTURER_BSD MANFCODE('B','S','D')
#define MANUFACTURER_BSE MANFCODE('B','S','E')
#define MANUFACTURER_BSM MANFCODE('B','S','M')
#define MANUFACTURER_BSP MANFCODE('B','S','P')
#define MANUFACTURER_BSS MANFCODE('B','S','S')
#define MANUFACTURER_BST MANFCODE('B','S','T')
#define MANUFACTURER_BSX MANFCODE('B','S','X')
#define MANUFACTURER_BTA MANFCODE('B','T','A')
#define MANUFACTURER_BTL MANFCODE('B','T','L')
#define MANUFACTURER_BTR MANFCODE('B','T','R')
#define MANUFACTURER_BTS MANFCODE('B','T','S')
#define MANUFACTURER_BUR MANFCODE('B','U','R')
#define MANUFACTURER_BUY MANFCODE('B','U','Y')
#define MANUFACTURER_BXC MANFCODE('B','X','C')
#define MANUFACTURER_BYD MANFCODE('B','Y','D')
#define MANUFACTURER_BYL MANFCODE('B','Y','L')
#define MANUFACTURER_BYW MANFCODE('B','Y','W')
#define MANUFACTURER_BZR MANFCODE('B','Z','R')
#define MANUFACTURER_CAB MANFCODE('C','A','B')
#define MANUFACTURER_CAD MANFCODE('C','A','D')
#define MANUFACTURER_CAH MANFCODE('C','A','H')
#define MANUFACTURER_CAL MANFCODE('C','A','L')
#define MANUFACTURER_CAR MANFCODE('C','A','R')
#define MANUFACTURER_CAT MANFCODE('C','A','T')
#define MANUFACTURER_CAV MANFCODE('C','A','V')
#define MANUFACTURER_CBI MANFCODE('C','B','I')
#define MANUFACTURER_CBS MANFCODE('C','B','S')
#define MANUFACTURER_CCS MANFCODE('C','C','S')
#define MANUFACTURER_CDA MANFCODE('C','D','A')
#define MANUFACTURER_CDL MANFCODE('C','D','L')
#define MANUFACTURER_CDT MANFCODE('C','D','T')
#define MANUFACTURER_CEB MANFCODE('C','E','B')
#define MANUFACTURER_CEG MANFCODE('C','E','G')
#define MANUFACTURER_CEL MANFCODE('C','E','L')
#define MANUFACTURER_CEM MANFCODE('C','E','M')
#define MANUFACTURER_CET MANFCODE('C','E','T')
#define MANUFACTURER_CGC MANFCODE('C','G','C')
#define MANUFACTURER_CGO MANFCODE('C','G','O')
#define MANUFACTURER_CHC MANFCODE('C','H','C')
#define MANUFACTURER_CHE MANFCODE('C','H','E')
#define MANUFACTURER_CHM MANFCODE('C','H','M')
#define MANUFACTURER_CHS MANFCODE('C','H','S')
#define MANUFACTURER_CIR MANFCODE('C','I','R')
#define MANUFACTURER_CJS MANFCODE('C','J','S')
#define MANUFACTURER_CKT MANFCODE('C','K','T')
#define MANUFACTURER_CLA MANFCODE('C','L','A')
#define MANUFACTURER_CLB MANFCODE('C','L','B')
#define MANUFACTURER_CLE MANFCODE('C','L','E')
#define MANUFACTURER_CLO MANFCODE('C','L','O')
#define MANUFACTURER_CLS MANFCODE('C','L','S')
#define MANUFACTURER_CLT MANFCODE('C','L','T')
#define MANUFACTURER_CLY MANFCODE('C','L','Y')
#define MANUFACTURER_CMC MANFCODE('C','M','C')
#define MANUFACTURER_CMP MANFCODE('C','M','P')
#define MANUFACTURER_CMS MANFCODE('C','M','S')
#define MANUFACTURER_CMT MANFCODE('C','M','T')
#define MANUFACTURER_CMV MANFCODE('C','M','V')
#define MANUFACTURER_CNM MANFCODE('C','N','M')
#define MANUFACTURER_CNU MANFCODE('C','N','U')
#define MANUFACTURER_COH MANFCODE('C','O','H')
#define MANUFACTURER_COM MANFCODE('C','O','M')
#define MANUFACTURER_CON MANFCODE('C','O','N')
#define MANUFACTURER_CPG MANFCODE('C','P','G')
#define MANUFACTURER_CPL MANFCODE('C','P','L')
#define MANUFACTURER_CPO MANFCODE('C','P','O')
#define MANUFACTURER_CPS MANFCODE('C','P','S')
#define MANUFACTURER_CQC MANFCODE('C','Q','C')
#define MANUFACTURER_CRD MANFCODE('C','R','D')
#define MANUFACTURER_CRT MANFCODE('C','R','T')
#define MANUFACTURER_CRW MANFCODE('C','R','W')
#define MANUFACTURER_CRX MANFCODE('C','R','X')
#define MANUFACTURER_CRY MANFCODE('C','R','Y')
#define MANUFACTURER_CSC MANFCODE('C','S','C')
#define MANUFACTURER_CSL MANFCODE('C','S','L')
#define MANUFACTURER_CSP MANFCODE('C','S','P')
#define MANUFACTURER_CTE MANFCODE('C','T','E')
#define MANUFACTURER_CTL MANFCODE('C','T','L')
#define MANUFACTURER_CTQ MANFCODE('C','T','Q')
#define MANUFACTURER_CTR MANFCODE('C','T','R')
#define MANUFACTURER_CTT MANFCODE('C','T','T')
#define MANUFACTURER_CTX MANFCODE('C','T','X')
#define MANUFACTURER_CUC MANFCODE('C','U','C')
#define MANUFACTURER_CUR MANFCODE('C','U','R')
#define MANUFACTURER_CWA MANFCODE('C','W','A')
#define MANUFACTURER_CWI MANFCODE('C','W','I')
#define MANUFACTURER_CWV MANFCODE('C','W','V')
#define MANUFACTURER_CYE MANFCODE('C','Y','E')
#define MANUFACTURER_CYI MANFCODE('C','Y','I')
#define MANUFACTURER_CYN MANFCODE('C','Y','N')
#define MANUFACTURER_CZA MANFCODE('C','Z','A')
#define MANUFACTURER_CZM MANFCODE('C','Z','M')
#define MANUFACTURER_DAE MANFCODE('D','A','E')
#define MANUFACTURER_DAF MANFCODE('D','A','F')
#define MANUFACTURER_DAN MANFCODE('D','A','N')
#define MANUFACTURER_DBE MANFCODE('D','B','E')
#define MANUFACTURER_DCD MANFCODE('D','C','D')
#define MANUFACTURER_DDE MANFCODE('D','D','E')
#define MANUFACTURER_DDI MANFCODE('D','D','I')
#define MANUFACTURER_DDL MANFCODE('D','D','L')
#define MANUFACTURER_DEA MANFCODE('D','E','A')
#define MANUFACTURER_DEC MANFCODE('D','E','C')
#define MANUFACTURER_DEL MANFCODE('D','E','L')
#define MANUFACTURER_DEN MANFCODE('D','E','N')
#define MANUFACTURER_DES MANFCODE('D','E','S')
#define MANUFACTURER_DEV MANFCODE('D','E','V')
#define MANUFACTURER_DFE MANFCODE('D','F','E')
#define MANUFACTURER_DFS MANFCODE('D','F','S')
#define MANUFACTURER_DGC MANFCODE('D','G','C')
#define MANUFACTURER_DGI MANFCODE('D','G','I')
#define MANUFACTURER_DGM MANFCODE('D','G','M')
#define MANUFACTURER_DGY MANFCODE('D','G','Y')
#define MANUFACTURER_DHA MANFCODE('D','H','A')
#define MANUFACTURER_DHQ MANFCODE('D','H','Q')
#define MANUFACTURER_DIE MANFCODE('D','I','E')
#define MANUFACTURER_DIG MANFCODE('D','I','G')
#define MANUFACTURER_DIL MANFCODE('D','I','L')
#define MANUFACTURER_DJA MANFCODE('D','J','A')
#define MANUFACTURER_DKY MANFCODE('D','K','Y')
#define MANUFACTURER_DLX MANFCODE('D','L','X')
#define MANUFACTURER_DMC MANFCODE('D','M','C')
#define MANUFACTURER_DME MANFCODE('D','M','E')
#define MANUFACTURER_DMP MANFCODE('D','M','P')
#define MANUFACTURER_DMS MANFCODE('D','M','S')
#define MANUFACTURER_DNB MANFCODE('D','N','B')
#define MANUFACTURER_DNO MANFCODE('D','N','O')
#define MANUFACTURER_DNT MANFCODE('D','N','T')
#define MANUFACTURER_DNV MANFCODE('D','N','V')
#define MANUFACTURER_DOM MANFCODE('D','O','M')
#define MANUFACTURER_DOS MANFCODE('D','O','S')
#define MANUFACTURER_DPM MANFCODE('D','P','M')
#define MANUFACTURER_DPP MANFCODE('D','P','P')
#define MANUFACTURER_DRC MANFCODE('D','R','C')
#define MANUFACTURER_DRT MANFCODE('D','R','T')
#define MANUFACTURER_DSE MANFCODE('D','S','E')
#define MANUFACTURER_DST MANFCODE('D','S','T')
#define MANUFACTURER_DUA MANFCODE('D','U','A')
#define MANUFACTURER_DVG MANFCODE('D','V','G')
#define MANUFACTURER_DVL MANFCODE('D','V','L')
#define MANUFACTURER_DWZ MANFCODE('D','W','Z')
#define MANUFACTURER_DZG MANFCODE('D','Z','G')
#define MANUFACTURER_EAA MANFCODE('E','A','A')
#define MANUFACTURER_EAD MANFCODE('E','A','D')
#define MANUFACTURER_EAH MANFCODE('E','A','H')
#define MANUFACTURER_EAS MANFCODE('E','A','S')
#define MANUFACTURER_EBK MANFCODE('E','B','K')
#define MANUFACTURER_EBV MANFCODE('E','B','V')
#define MANUFACTURER_EBZ MANFCODE('E','B','Z')
#define MANUFACTURER_ECA MANFCODE('E','C','A')
#define MANUFACTURER_ECC MANFCODE('E','C','C')
#define MANUFACTURER_ECH MANFCODE('E','C','H')
#define MANUFACTURER_ECL MANFCODE('E','C','L')
#define MANUFACTURER_ECM MANFCODE('E','C','M')
#define MANUFACTURER_ECO MANFCODE('E','C','O')
#define MANUFACTURER_ECS MANFCODE('E','C','S')
#define MANUFACTURER_EDI MANFCODE('E','D','I')
#define MANUFACTURER_EDM MANFCODE('E','D','M')
#define MANUFACTURER_EEC MANFCODE('E','E','C')
#define MANUFACTURER_EEE MANFCODE('E','E','E')
#define MANUFACTURER_EEO MANFCODE('E','E','O')
#define MANUFACTURER_EEP MANFCODE('E','E','P')
#define MANUFACTURER_EES MANFCODE('E','E','S')
#define MANUFACTURER_EFA MANFCODE('E','F','A')
#define MANUFACTURER_EFE MANFCODE('E','F','E')
#define MANUFACTURER_EFI MANFCODE('E','F','I')
#define MANUFACTURER_EFN MANFCODE('E','F','N')
#define MANUFACTURER_EFR MANFCODE('E','F','R')
#define MANUFACTURER_EFS MANFCODE('E','F','S')
#define MANUFACTURER_EGA MANFCODE('E','G','A')
#define MANUFACTURER_EGC MANFCODE('E','G','C')
#define MANUFACTURER_EGD MANFCODE('E','G','D')
#define MANUFACTURER_EGM MANFCODE('E','G','M')
#define MANUFACTURER_EGW MANFCODE('E','G','W')
#define MANUFACTURER_EGY MANFCODE('E','G','Y')
#define MANUFACTURER_EHL MANFCODE('E','H','L')
#define MANUFACTURER_EIE MANFCODE('E','I','E')
#define MANUFACTURER_EIP MANFCODE('E','I','P')
#define MANUFACTURER_EIT MANFCODE('E','I','T')
#define MANUFACTURER_EKA MANFCODE('E','K','A')
#define MANUFACTURER_EKO MANFCODE('E','K','O')
#define MANUFACTURER_EKS MANFCODE('E','K','S')
#define MANUFACTURER_EKT MANFCODE('E','K','T')
#define MANUFACTURER_ELC MANFCODE('E','L','C')
#define MANUFACTURER_ELD MANFCODE('E','L','D')
#define MANUFACTURER_ELE MANFCODE('E','L','E')
#define MANUFACTURER_ELG MANFCODE('E','L','G')
#define MANUFACTURER_ELL MANFCODE('E','L','L')
#define MANUFACTURER_ELM MANFCODE('E','L','M')
#define MANUFACTURER_ELO MANFCODE('E','L','O')
#define MANUFACTURER_ELQ MANFCODE('E','L','Q')
#define MANUFACTURER_ELR MANFCODE('E','L','R')
#define MANUFACTURER_ELS MANFCODE('E','L','S')
#define MANUFACTURER_ELT MANFCODE('E','L','T')
#define MANUFACTURER_ELV MANFCODE('E','L','V')
#define MANUFACTURER_EMB MANFCODE('E','M','B')
#define MANUFACTURER_EMC MANFCODE('E','M','C')
#define MANUFACTURER_EME MANFCODE('E','M','E')
#define MANUFACTURER_EMF MANFCODE('E','M','F')
#define MANUFACTURER_EMH MANFCODE('E','M','H')
#define MANUFACTURER_EMI MANFCODE('E','M','I')
#define MANUFACTURER_EML MANFCODE('E','M','L')
#define MANUFACTURER_EMM MANFCODE('E','M','M')
#define MANUFACTURER_EMO MANFCODE('E','M','O')
#define MANUFACTURER_EMR MANFCODE('E','M','R')
#define MANUFACTURER_EMS MANFCODE('E','M','S')
#define MANUFACTURER_EMT MANFCODE('E','M','T')
#define MANUFACTURER_EMU MANFCODE('E','M','U')
#define MANUFACTURER_END MANFCODE('E','N','D')
#define MANUFACTURER_ENE MANFCODE('E','N','E')
#define MANUFACTURER_ENG MANFCODE('E','N','G')
#define MANUFACTURER_ENH MANFCODE('E','N','H')
#define MANUFACTURER_ENI MANFCODE('E','N','I')
#define MANUFACTURER_ENL MANFCODE('E','N','L')
#define MANUFACTURER_ENN MANFCODE('E','N','N')
#define MANUFACTURER_ENO MANFCODE('E','N','O')
#define MANUFACTURER_ENP MANFCODE('E','N','P')
#define MANUFACTURER_ENR MANFCODE('E','N','R')
#define MANUFACTURER_ENS MANFCODE('E','N','S')
#define MANUFACTURER_ENT MANFCODE('E','N','T')
#define MANUFACTURER_ENX MANFCODE('E','N','X')
#define MANUFACTURER_EPI MANFCODE('E','P','I')
#define MANUFACTURER_EPL MANFCODE('E','P','L')
#define MANUFACTURER_ERE MANFCODE('E','R','E')
#define MANUFACTURER_ERI MANFCODE('E','R','I')
#define MANUFACTURER_ERL MANFCODE('E','R','L')
#define MANUFACTURER_ERN MANFCODE('E','R','N')
#define MANUFACTURER_ERS MANFCODE('E','R','S')
#define MANUFACTURER_ESA MANFCODE('E','S','A')
#define MANUFACTURER_ESC MANFCODE('E','S','C')
#define MANUFACTURER_ESD MANFCODE('E','S','D')
#define MANUFACTURER_ESE MANFCODE('E','S','E')
#define MANUFACTURER_ESG MANFCODE('E','S','G')
#define MANUFACTURER_ESH MANFCODE('E','S','H')
#define MANUFACTURER_ESI MANFCODE('E','S','I')
#define MANUFACTURER_ESM MANFCODE('E','S','M')
#define MANUFACTURER_ESN MANFCODE('E','S','N')
#define MANUFACTURER_ESO MANFCODE('E','S','O')
#define MANUFACTURER_ESP MANFCODE('E','S','P')
#define MANUFACTURER_ESR MANFCODE('E','S','R')
#define MANUFACTURER_ESS MANFCODE('E','S','S')
#define MANUFACTURER_ESV MANFCODE('E','S','V')
#define MANUFACTURER_ESY MANFCODE('E','S','Y')
#define MANUFACTURER_ETD MANFCODE('E','T','D')
#define MANUFACTURER_ETK MANFCODE('E','T','K')
#define MANUFACTURER_ETO MANFCODE('E','T','O')
#define MANUFACTURER_ETP MANFCODE('E','T','P')
#define MANUFACTURER_EUE MANFCODE('E','U','E')
#define MANUFACTURER_EUR MANFCODE('E','U','R')
#define MANUFACTURER_EUS MANFCODE('E','U','S')
#define MANUFACTURER_EVD MANFCODE('E','V','D')
#define MANUFACTURER_EVK MANFCODE('E','V','K')
#define MANUFACTURER_EVL MANFCODE('E','V','L')
#define MANUFACTURER_EWA MANFCODE('E','W','A')
#define MANUFACTURER_EWG MANFCODE('E','W','G')
#define MANUFACTURER_EWS MANFCODE('E','W','S')
#define MANUFACTURER_EWT MANFCODE('E','W','T')
#define MANUFACTURER_EXS MANFCODE('E','X','S')
#define MANUFACTURER_EXT MANFCODE('E','X','T')
#define MANUFACTURER_EYE MANFCODE('E','Y','E')
#define MANUFACTURER_EYT MANFCODE('E','Y','T')
#define MANUFACTURER_FAE MANFCODE('F','A','E')
#define MANUFACTURER_FAN MANFCODE('F','A','N')
#define MANUFACTURER_FAR MANFCODE('F','A','R')
#define MANUFACTURER_FAS MANFCODE('F','A','S')
#define MANUFACTURER_FED MANFCODE('F','E','D')
#define MANUFACTURER_FEM MANFCODE('F','E','M')
#define MANUFACTURER_FFD MANFCODE('F','F','D')
#define MANUFACTURER_FID MANFCODE('F','I','D')
#define MANUFACTURER_FIM MANFCODE('F','I','M')
#define MANUFACTURER_FIN MANFCODE('F','I','N')
#define MANUFACTURER_FIO MANFCODE('F','I','O')
#define MANUFACTURER_FLA MANFCODE('F','L','A')
#define MANUFACTURER_FLD MANFCODE('F','L','D')
#define MANUFACTURER_FLE MANFCODE('F','L','E')
#define MANUFACTURER_FLG MANFCODE('F','L','G')
#define MANUFACTURER_FLO MANFCODE('F','L','O')
#define MANUFACTURER_FLS MANFCODE('F','L','S')
#define MANUFACTURER_FLU MANFCODE('F','L','U')
#define MANUFACTURER_FLW MANFCODE('F','L','W')
#define MANUFACTURER_FLX MANFCODE('F','L','X')
#define MANUFACTURER_FMG MANFCODE('F','M','G')
#define MANUFACTURER_FML MANFCODE('F','M','L')
#define MANUFACTURER_FMM MANFCODE('F','M','M')
#define MANUFACTURER_FNX MANFCODE('F','N','X')
#define MANUFACTURER_FPL MANFCODE('F','P','L')
#define MANUFACTURER_FPR MANFCODE('F','P','R')
#define MANUFACTURER_FRC MANFCODE('F','R','C')
#define MANUFACTURER_FRE MANFCODE('F','R','E')
#define MANUFACTURER_FRU MANFCODE('F','R','U')
#define MANUFACTURER_FSP MANFCODE('F','S','P')
#define MANUFACTURER_FST MANFCODE('F','S','T')
#define MANUFACTURER_FSY MANFCODE('F','S','Y')
#define MANUFACTURER_FTL MANFCODE('F','T','L')
#define MANUFACTURER_FUS MANFCODE('F','U','S')
#define MANUFACTURER_FUT MANFCODE('F','U','T')
#define MANUFACTURER_FWS MANFCODE('F','W','S')
#define MANUFACTURER_FZK MANFCODE('F','Z','K')
#define MANUFACTURER_GAT MANFCODE('G','A','T')
#define MANUFACTURER_GAV MANFCODE('G','A','V')
#define MANUFACTURER_GBJ MANFCODE('G','B','J')
#define MANUFACTURER_GCE MANFCODE('G','C','E')
#define MANUFACTURER_GCG MANFCODE('G','C','G')
#define MANUFACTURER_GDC MANFCODE('G','D','C')
#define MANUFACTURER_GDS MANFCODE('G','D','S')
#define MANUFACTURER_GEC MANFCODE('G','E','C')
#define MANUFACTURER_GEE MANFCODE('G','E','E')
#define MANUFACTURER_GEL MANFCODE('G','E','L')
#define MANUFACTURER_GEN MANFCODE('G','E','N')
#define MANUFACTURER_GEO MANFCODE('G','E','O')
#define MANUFACTURER_GEP MANFCODE('G','E','P')
#define MANUFACTURER_GET MANFCODE('G','E','T')
#define MANUFACTURER_GEX MANFCODE('G','E','X')
#define MANUFACTURER_GFM MANFCODE('G','F','M')
#define MANUFACTURER_GIL MANFCODE('G','I','L')
#define MANUFACTURER_GIN MANFCODE('G','I','N')
#define MANUFACTURER_GIO MANFCODE('G','I','O')
#define MANUFACTURER_GLM MANFCODE('G','L','M')
#define MANUFACTURER_GLX MANFCODE('G','L','X')
#define MANUFACTURER_GMC MANFCODE('G','M','C')
#define MANUFACTURER_GME MANFCODE('G','M','E')
#define MANUFACTURER_GMM MANFCODE('G','M','M')
#define MANUFACTURER_GMS MANFCODE('G','M','S')
#define MANUFACTURER_GMT MANFCODE('G','M','T')
#define MANUFACTURER_GNP MANFCODE('G','N','P')
#define MANUFACTURER_GNY MANFCODE('G','N','Y')
#define MANUFACTURER_GOE MANFCODE('G','O','E')
#define MANUFACTURER_GPM MANFCODE('G','P','M')
#define MANUFACTURER_GRA MANFCODE('G','R','A')
#define MANUFACTURER_GRD MANFCODE('G','R','D')
#define MANUFACTURER_GRE MANFCODE('G','R','E')
#define MANUFACTURER_GRI MANFCODE('G','R','I')
#define MANUFACTURER_GRP MANFCODE('G','R','P')
#define MANUFACTURER_GRS MANFCODE('G','R','S')
#define MANUFACTURER_GRX MANFCODE('G','R','X')
#define MANUFACTURER_GSE MANFCODE('G','S','E')
#define MANUFACTURER_GSP MANFCODE('G','S','P')
#define MANUFACTURER_GSS MANFCODE('G','S','S')
#define MANUFACTURER_GST MANFCODE('G','S','T')
#define MANUFACTURER_GTE MANFCODE('G','T','E')
#define MANUFACTURER_GTM MANFCODE('G','T','M')
#define MANUFACTURER_GTR MANFCODE('G','T','R')
#define MANUFACTURER_GTS MANFCODE('G','T','S')
#define MANUFACTURER_GUH MANFCODE('G','U','H')
#define MANUFACTURER_GWF MANFCODE('G','W','F')
#define MANUFACTURER_GWI MANFCODE('G','W','I')
#define MANUFACTURER_HAG MANFCODE('H','A','G')
#define MANUFACTURER_HAK MANFCODE('H','A','K')
#define MANUFACTURER_HBY MANFCODE('H','B','Y')
#define MANUFACTURER_HCE MANFCODE('H','C','E')
#define MANUFACTURER_HCM MANFCODE('H','C','M')
#define MANUFACTURER_HDK MANFCODE('H','D','K')
#define MANUFACTURER_HDX MANFCODE('H','D','X')
#define MANUFACTURER_HDY MANFCODE('H','D','Y')
#define MANUFACTURER_HEG MANFCODE('H','E','G')
#define MANUFACTURER_HEI MANFCODE('H','E','I')
#define MANUFACTURER_HEK MANFCODE('H','E','K')
#define MANUFACTURER_HEL MANFCODE('H','E','L')
#define MANUFACTURER_HEM MANFCODE('H','E','M')
#define MANUFACTURER_HER MANFCODE('H','E','R')
#define MANUFACTURER_HEW MANFCODE('H','E','W')
#define MANUFACTURER_HEX MANFCODE('H','E','X')
#define MANUFACTURER_HFI MANFCODE('H','F','I')
#define MANUFACTURER_HFL MANFCODE('H','F','L')
#define MANUFACTURER_HFR MANFCODE('H','F','R')
#define MANUFACTURER_HGM MANFCODE('H','G','M')
#define MANUFACTURER_HHE MANFCODE('H','H','E')
#define MANUFACTURER_HHM MANFCODE('H','H','M')
#define MANUFACTURER_HIE MANFCODE('H','I','E')
#define MANUFACTURER_HIN MANFCODE('H','I','N')
#define MANUFACTURER_HIT MANFCODE('H','I','T')
#define MANUFACTURER_HJM MANFCODE('H','J','M')
#define MANUFACTURER_HKK MANFCODE('H','K','K')
#define MANUFACTURER_HLY MANFCODE('H','L','Y')
#define MANUFACTURER_HMI MANFCODE('H','M','I')
#define MANUFACTURER_HML MANFCODE('H','M','L')
#define MANUFACTURER_HMS MANFCODE('H','M','S')
#define MANUFACTURER_HMT MANFCODE('H','M','T')
#define MANUFACTURER_HMU MANFCODE('H','M','U')
#define MANUFACTURER_HND MANFCODE('H','N','D')
#define MANUFACTURER_HOE MANFCODE('H','O','E')
#define MANUFACTURER_HOL MANFCODE('H','O','L')
#define MANUFACTURER_HON MANFCODE('H','O','N')
#define MANUFACTURER_HOY MANFCODE('H','O','Y')
#define MANUFACTURER_HPL MANFCODE('H','P','L')
#define MANUFACTURER_HPM MANFCODE('H','P','M')
#define MANUFACTURER_HRM MANFCODE('H','R','M')
#define MANUFACTURER_HRS MANFCODE('H','R','S')
#define MANUFACTURER_HSD MANFCODE('H','S','D')
#define MANUFACTURER_HST MANFCODE('H','S','T')
#define MANUFACTURER_HTC MANFCODE('H','T','C')
#define MANUFACTURER_HTI MANFCODE('H','T','I')
#define MANUFACTURER_HTL MANFCODE('H','T','L')
#define MANUFACTURER_HTS MANFCODE('H','T','S')
#define MANUFACTURER_HUK MANFCODE('H','U','K')
#define MANUFACTURER_HUM MANFCODE('H','U','M')
#define MANUFACTURER_HVG MANFCODE('H','V','G')
#define MANUFACTURER_HVT MANFCODE('H','V','T')
#define MANUFACTURER_HWC MANFCODE('H','W','C')
#define MANUFACTURER_HWM MANFCODE('H','W','M')
#define MANUFACTURER_HWT MANFCODE('H','W','T')
#define MANUFACTURER_HXD MANFCODE('H','X','D')
#define MANUFACTURER_HXE MANFCODE('H','X','E')
#define MANUFACTURER_HXW MANFCODE('H','X','W')
#define MANUFACTURER_HYD MANFCODE('H','Y','D')
#define MANUFACTURER_HYE MANFCODE('H','Y','E')
#define MANUFACTURER_HYG MANFCODE('H','Y','G')
#define MANUFACTURER_HYS MANFCODE('H','Y','S')
#define MANUFACTURER_HZC MANFCODE('H','Z','C')
#define MANUFACTURER_HZI MANFCODE('H','Z','I')
#define MANUFACTURER_HZZ MANFCODE('H','Z','Z')
#define MANUFACTURER_IAC MANFCODE('I','A','C')
#define MANUFACTURER_IBE MANFCODE('I','B','E')
#define MANUFACTURER_IBG MANFCODE('I','B','G')
#define MANUFACTURER_ICB MANFCODE('I','C','B')
#define MANUFACTURER_ICE MANFCODE('I','C','E')
#define MANUFACTURER_ICK MANFCODE('I','C','K')
#define MANUFACTURER_ICM MANFCODE('I','C','M')
#define MANUFACTURER_ICP MANFCODE('I','C','P')
#define MANUFACTURER_ICS MANFCODE('I','C','S')
#define MANUFACTURER_ICT MANFCODE('I','C','T')
#define MANUFACTURER_ICU MANFCODE('I','C','U')
#define MANUFACTURER_IDE MANFCODE('I','D','E')
#define MANUFACTURER_IDS MANFCODE('I','D','S')
#define MANUFACTURER_IEC MANFCODE('I','E','C')
#define MANUFACTURER_IEE MANFCODE('I','E','E')
#define MANUFACTURER_IEI MANFCODE('I','E','I')
#define MANUFACTURER_IEN MANFCODE('I','E','N')
#define MANUFACTURER_IES MANFCODE('I','E','S')
#define MANUFACTURER_IFC MANFCODE('I','F','C')
#define MANUFACTURER_IFX MANFCODE('I','F','X')
#define MANUFACTURER_IGR MANFCODE('I','G','R')
#define MANUFACTURER_IGS MANFCODE('I','G','S')
#define MANUFACTURER_IHM MANFCODE('I','H','M')
#define MANUFACTURER_IID MANFCODE('I','I','D')
#define MANUFACTURER_IIF MANFCODE('I','I','F')
#define MANUFACTURER_IJE MANFCODE('I','J','E')
#define MANUFACTURER_IJK MANFCODE('I','J','K')
#define MANUFACTURER_IKE MANFCODE('I','K','E')
#define MANUFACTURER_IKM MANFCODE('I','K','M')
#define MANUFACTURER_IKS MANFCODE('I','K','S')
#define MANUFACTURER_IMC MANFCODE('I','M','C')
#define MANUFACTURER_IME MANFCODE('I','M','E')
#define MANUFACTURER_IMR MANFCODE('I','M','R')
#define MANUFACTURER_IMS MANFCODE('I','M','S')
#define MANUFACTURER_IMT MANFCODE('I','M','T')
#define MANUFACTURER_IMZ MANFCODE('I','M','Z')
#define MANUFACTURER_INC MANFCODE('I','N','C')
#define MANUFACTURER_IND MANFCODE('I','N','D')
#define MANUFACTURER_INE MANFCODE('I','N','E')
#define MANUFACTURER_INF MANFCODE('I','N','F')
#define MANUFACTURER_INI MANFCODE('I','N','I')
#define MANUFACTURER_INM MANFCODE('I','N','M')
#define MANUFACTURER_INN MANFCODE('I','N','N')
#define MANUFACTURER_INO MANFCODE('I','N','O')
#define MANUFACTURER_INP MANFCODE('I','N','P')
#define MANUFACTURER_INS MANFCODE('I','N','S')
#define MANUFACTURER_INT MANFCODE('I','N','T')
#define MANUFACTURER_INV MANFCODE('I','N','V')
#define MANUFACTURER_INX MANFCODE('I','N','X')
#define MANUFACTURER_IOT MANFCODE('I','O','T')
#define MANUFACTURER_IPD MANFCODE('I','P','D')
#define MANUFACTURER_IQO MANFCODE('I','Q','O')
#define MANUFACTURER_IQS MANFCODE('I','Q','S')
#define MANUFACTURER_IRE MANFCODE('I','R','E')
#define MANUFACTURER_ISA MANFCODE('I','S','A')
#define MANUFACTURER_ISE MANFCODE('I','S','E')
#define MANUFACTURER_ISF MANFCODE('I','S','F')
#define MANUFACTURER_ISI MANFCODE('I','S','I')
#define MANUFACTURER_ISK MANFCODE('I','S','K')
#define MANUFACTURER_ISO MANFCODE('I','S','O')
#define MANUFACTURER_ISS MANFCODE('I','S','S')
#define MANUFACTURER_IST MANFCODE('I','S','T')
#define MANUFACTURER_ITA MANFCODE('I','T','A')
#define MANUFACTURER_ITB MANFCODE('I','T','B')
#define MANUFACTURER_ITC MANFCODE('I','T','C')
#define MANUFACTURER_ITE MANFCODE('I','T','E')
#define MANUFACTURER_ITF MANFCODE('I','T','F')
#define MANUFACTURER_ITG MANFCODE('I','T','G')
#define MANUFACTURER_ITH MANFCODE('I','T','H')
#define MANUFACTURER_ITI MANFCODE('I','T','I')
#define MANUFACTURER_ITK MANFCODE('I','T','K')
#define MANUFACTURER_ITL MANFCODE('I','T','L')
#define MANUFACTURER_ITP MANFCODE('I','T','P')
#define MANUFACTURER_ITR MANFCODE('I','T','R')
#define MANUFACTURER_ITS MANFCODE('I','T','S')
#define MANUFACTURER_ITU MANFCODE('I','T','U')
#define MANUFACTURER_ITW MANFCODE('I','T','W')
#define MANUFACTURER_ITX MANFCODE('I','T','X')
#define MANUFACTURER_ITZ MANFCODE('I','T','Z')
#define MANUFACTURER_IUS MANFCODE('I','U','S')
#define MANUFACTURER_IVY MANFCODE('I','V','Y')
#define MANUFACTURER_IWD MANFCODE('I','W','D')
#define MANUFACTURER_IWK MANFCODE('I','W','K')
#define MANUFACTURER_IYI MANFCODE('I','Y','I')
#define MANUFACTURER_IZE MANFCODE('I','Z','E')
#define MANUFACTURER_JAC MANFCODE('J','A','C')
#define MANUFACTURER_JAN MANFCODE('J','A','N')
#define MANUFACTURER_JBF MANFCODE('J','B','F')
#define MANUFACTURER_JCE MANFCODE('J','C','E')
#define MANUFACTURER_JED MANFCODE('J','E','D')
#define MANUFACTURER_JGD MANFCODE('J','G','D')
#define MANUFACTURER_JGF MANFCODE('J','G','F')
#define MANUFACTURER_JGH MANFCODE('J','G','H')
#define MANUFACTURER_JHA MANFCODE('J','H','A')
#define MANUFACTURER_JHM MANFCODE('J','H','M')
#define MANUFACTURER_JJN MANFCODE('J','J','N')
#define MANUFACTURER_JKW MANFCODE('J','K','W')
#define MANUFACTURER_JMT MANFCODE('J','M','T')
#define MANUFACTURER_JNC MANFCODE('J','N','C')
#define MANUFACTURER_JNJ MANFCODE('J','N','J')
#define MANUFACTURER_JOY MANFCODE('J','O','Y')
#define MANUFACTURER_JSM MANFCODE('J','S','M')
#define MANUFACTURER_JSO MANFCODE('J','S','O')
#define MANUFACTURER_JUM MANFCODE('J','U','M')
#define MANUFACTURER_JWH MANFCODE('J','W','H')
#define MANUFACTURER_JWR MANFCODE('J','W','R')
#define MANUFACTURER_JWS MANFCODE('J','W','S')
#define MANUFACTURER_JYS MANFCODE('J','Y','S')
#define MANUFACTURER_KAA MANFCODE('K','A','A')
#define MANUFACTURER_KAC MANFCODE('K','A','C')
#define MANUFACTURER_KAL MANFCODE('K','A','L')
#define MANUFACTURER_KAM MANFCODE('K','A','M')
#define MANUFACTURER_KAR MANFCODE('K','A','R')
#define MANUFACTURER_KAS MANFCODE('K','A','S')
#define MANUFACTURER_KAT MANFCODE('K','A','T')
#define MANUFACTURER_KAW MANFCODE('K','A','W')
#define MANUFACTURER_KBH MANFCODE('K','B','H')
#define MANUFACTURER_KBK MANFCODE('K','B','K')
#define MANUFACTURER_KBN MANFCODE('K','B','N')
#define MANUFACTURER_KDN MANFCODE('K','D','N')
#define MANUFACTURER_KDS MANFCODE('K','D','S')
#define MANUFACTURER_KEE MANFCODE('K','E','E')
#define MANUFACTURER_KEL MANFCODE('K','E','L')
#define MANUFACTURER_KER MANFCODE('K','E','R')
#define MANUFACTURER_KES MANFCODE('K','E','S')
#define MANUFACTURER_KFM MANFCODE('K','F','M')
#define MANUFACTURER_KFM MANFCODE('K','F','M')
#define MANUFACTURER_KGE MANFCODE('K','G','E')
#define MANUFACTURER_KHL MANFCODE('K','H','L')
#define MANUFACTURER_KIG MANFCODE('K','I','G')
#define MANUFACTURER_KJN MANFCODE('K','J','N')
#define MANUFACTURER_KKE MANFCODE('K','K','E')
#define MANUFACTURER_KLE MANFCODE('K','L','E')
#define MANUFACTURER_KLK MANFCODE('K','L','K')
#define MANUFACTURER_KMB MANFCODE('K','M','B')
#define MANUFACTURER_KMT MANFCODE('K','M','T')
#define MANUFACTURER_KNI MANFCODE('K','N','I')
#define MANUFACTURER_KNX MANFCODE('K','N','X')
#define MANUFACTURER_KPD MANFCODE('K','P','D')
#define MANUFACTURER_KRO MANFCODE('K','R','O')
#define MANUFACTURER_KRT MANFCODE('K','R','T')
#define MANUFACTURER_KSM MANFCODE('K','S','M')
#define MANUFACTURER_KST MANFCODE('K','S','T')
#define MANUFACTURER_KSY MANFCODE('K','S','Y')
#define MANUFACTURER_KTC MANFCODE('K','T','C')
#define MANUFACTURER_KZK MANFCODE('K','Z','K')
#define MANUFACTURER_LAC MANFCODE('L','A','C')
#define MANUFACTURER_LAI MANFCODE('L','A','I')
#define MANUFACTURER_LAN MANFCODE('L','A','N')
#define MANUFACTURER_LAS MANFCODE('L','A','S')
#define MANUFACTURER_LCG MANFCODE('L','C','G')
#define MANUFACTURER_LCR MANFCODE('L','C','R')
#define MANUFACTURER_LDE MANFCODE('L','D','E')
#define MANUFACTURER_LEC MANFCODE('L','E','C')
#define MANUFACTURER_LEI MANFCODE('L','E','I')
#define MANUFACTURER_LEM MANFCODE('L','E','M')
#define MANUFACTURER_LES MANFCODE('L','E','S')
#define MANUFACTURER_LET MANFCODE('L','E','T')
#define MANUFACTURER_LFS MANFCODE('L','F','S')
#define MANUFACTURER_LGA MANFCODE('L','G','A')
#define MANUFACTURER_LGB MANFCODE('L','G','B')
#define MANUFACTURER_LGC MANFCODE('L','G','C')
#define MANUFACTURER_LGD MANFCODE('L','G','D')
#define MANUFACTURER_LGF MANFCODE('L','G','F')
#define MANUFACTURER_LGG MANFCODE('L','G','G')
#define MANUFACTURER_LGI MANFCODE('L','G','I')
#define MANUFACTURER_LGS MANFCODE('L','G','S')
#define MANUFACTURER_LGU MANFCODE('L','G','U')
#define MANUFACTURER_LGZ MANFCODE('L','G','Z')
#define MANUFACTURER_LHA MANFCODE('L','H','A')
#define MANUFACTURER_LIN MANFCODE('L','I','N')
#define MANUFACTURER_LIT MANFCODE('L','I','T')
#define MANUFACTURER_LJP MANFCODE('L','J','P')
#define MANUFACTURER_LLM MANFCODE('L','L','M')
#define MANUFACTURER_LMC MANFCODE('L','M','C')
#define MANUFACTURER_LMG MANFCODE('L','M','G')
#define MANUFACTURER_LML MANFCODE('L','M','L')
#define MANUFACTURER_LMP MANFCODE('L','M','P')
#define MANUFACTURER_LMS MANFCODE('L','M','S')
#define MANUFACTURER_LNC MANFCODE('L','N','C')
#define MANUFACTURER_LNK MANFCODE('L','N','K')
#define MANUFACTURER_LNT MANFCODE('L','N','T')
#define MANUFACTURER_LOB MANFCODE('L','O','B')
#define MANUFACTURER_LOG MANFCODE('L','O','G')
#define MANUFACTURER_LOV MANFCODE('L','O','V')
#define MANUFACTURER_LSC MANFCODE('L','S','C')
#define MANUFACTURER_LSE MANFCODE('L','S','E')
#define MANUFACTURER_LSK MANFCODE('L','S','K')
#define MANUFACTURER_LSP MANFCODE('L','S','P')
#define MANUFACTURER_LSZ MANFCODE('L','S','Z')
#define MANUFACTURER_LTO MANFCODE('L','T','O')
#define MANUFACTURER_LUG MANFCODE('L','U','G')
#define MANUFACTURER_LUN MANFCODE('L','U','N')
#define MANUFACTURER_LWT MANFCODE('L','W','T')
#define MANUFACTURER_LYE MANFCODE('L','Y','E')
#define MANUFACTURER_MAC MANFCODE('M','A','C')
#define MANUFACTURER_MAD MANFCODE('M','A','D')
#define MANUFACTURER_MAE MANFCODE('M','A','E')
#define MANUFACTURER_MAG MANFCODE('M','A','G')
#define MANUFACTURER_MAH MANFCODE('M','A','H')
#define MANUFACTURER_MAN MANFCODE('M','A','N')
#define MANUFACTURER_MAT MANFCODE('M','A','T')
#define MANUFACTURER_MAX MANFCODE('M','A','X')
#define MANUFACTURER_MBS MANFCODE('M','B','S')
#define MANUFACTURER_MCP MANFCODE('M','C','P')
#define MANUFACTURER_MCR MANFCODE('M','C','R')
#define MANUFACTURER_MCS MANFCODE('M','C','S')
#define MANUFACTURER_MDA MANFCODE('M','D','A')
#define MANUFACTURER_MDE MANFCODE('M','D','E')
#define MANUFACTURER_MDL MANFCODE('M','D','L')
#define MANUFACTURER_MDX MANFCODE('M','D','X')
#define MANUFACTURER_MEC MANFCODE('M','E','C')
#define MANUFACTURER_MED MANFCODE('M','E','D')
#define MANUFACTURER_MEE MANFCODE('M','E','E')
#define MANUFACTURER_MEH MANFCODE('M','E','H')
#define MANUFACTURER_MEI MANFCODE('M','E','I')
#define MANUFACTURER_MEL MANFCODE('M','E','L')
#define MANUFACTURER_MEM MANFCODE('M','E','M')
#define MANUFACTURER_MES MANFCODE('M','E','S')
#define MANUFACTURER_MET MANFCODE('M','E','T')
#define MANUFACTURER_MHT MANFCODE('M','H','T')
#define MANUFACTURER_MIC MANFCODE('M','I','C')
#define MANUFACTURER_MID MANFCODE('M','I','D')
#define MANUFACTURER_MII MANFCODE('M','I','I')
#define MANUFACTURER_MIJ MANFCODE('M','I','J')
#define MANUFACTURER_MIK MANFCODE('M','I','K')
#define MANUFACTURER_MIL MANFCODE('M','I','L')
#define MANUFACTURER_MIM MANFCODE('M','I','M')
#define MANUFACTURER_MIR MANFCODE('M','I','R')
#define MANUFACTURER_MIS MANFCODE('M','I','S')
#define MANUFACTURER_MIT MANFCODE('M','I','T')
#define MANUFACTURER_MKA MANFCODE('M','K','A')
#define MANUFACTURER_MKE MANFCODE('M','K','E')
#define MANUFACTURER_MKL MANFCODE('M','K','L')
#define MANUFACTURER_MKS MANFCODE('M','K','S')
#define MANUFACTURER_MLQ MANFCODE('M','L','Q')
#define MANUFACTURER_MLR MANFCODE('M','L','R')
#define MANUFACTURER_MMC MANFCODE('M','M','C')
#define MANUFACTURER_MMF MANFCODE('M','M','F')
#define MANUFACTURER_MMI MANFCODE('M','M','I')
#define MANUFACTURER_MMM MANFCODE('M','M','M')
#define MANUFACTURER_MMP MANFCODE('M','M','P')
#define MANUFACTURER_MMS MANFCODE('M','M','S')
#define MANUFACTURER_MMT MANFCODE('M','M','T')
#define MANUFACTURER_MNS MANFCODE('M','N','S')
#define MANUFACTURER_MNW MANFCODE('M','N','W')
#define MANUFACTURER_MOJ MANFCODE('M','O','J')
#define MANUFACTURER_MOS MANFCODE('M','O','S')
#define MANUFACTURER_MOT MANFCODE('M','O','T')
#define MANUFACTURER_MPA MANFCODE('M','P','A')
#define MANUFACTURER_MPR MANFCODE('M','P','R')
#define MANUFACTURER_MPS MANFCODE('M','P','S')
#define MANUFACTURER_MRN MANFCODE('M','R','N')
#define MANUFACTURER_MRT MANFCODE('M','R','T')
#define MANUFACTURER_MSB MANFCODE('M','S','B')
#define MANUFACTURER_MSE MANFCODE('M','S','E')
#define MANUFACTURER_MSM MANFCODE('M','S','M')
#define MANUFACTURER_MSO MANFCODE('M','S','O')
#define MANUFACTURER_MST MANFCODE('M','S','T')
#define MANUFACTURER_MSY MANFCODE('M','S','Y')
#define MANUFACTURER_MTC MANFCODE('M','T','C')
#define MANUFACTURER_MTD MANFCODE('M','T','D')
#define MANUFACTURER_MTH MANFCODE('M','T','H')
#define MANUFACTURER_MTI MANFCODE('M','T','I')
#define MANUFACTURER_MTL MANFCODE('M','T','L')
#define MANUFACTURER_MTM MANFCODE('M','T','M')
#define MANUFACTURER_MTN MANFCODE('M','T','N')
#define MANUFACTURER_MTP MANFCODE('M','T','P')
#define MANUFACTURER_MTR MANFCODE('M','T','R')
#define MANUFACTURER_MTS MANFCODE('M','T','S')
#define MANUFACTURER_MTX MANFCODE('M','T','X')
#define MANUFACTURER_MUK MANFCODE('M','U','K')
#define MANUFACTURER_MWI MANFCODE('M','W','I')
#define MANUFACTURER_MWU MANFCODE('M','W','U')
#define MANUFACTURER_MXM MANFCODE('M','X','M')
#define MANUFACTURER_MYS MANFCODE('M','Y','S')
#define MANUFACTURER_NAE MANFCODE('N','A','E')
#define MANUFACTURER_NAR MANFCODE('N','A','R')
#define MANUFACTURER_NAS MANFCODE('N','A','S')
#define MANUFACTURER_NAS MANFCODE('N','A','S')
#define MANUFACTURER_NAT MANFCODE('N','A','T')
#define MANUFACTURER_NCK MANFCODE('N','C','K')
#define MANUFACTURER_NDF MANFCODE('N','D','F')
#define MANUFACTURER_NDM MANFCODE('N','D','M')
#define MANUFACTURER_NEE MANFCODE('N','E','E')
#define MANUFACTURER_NER MANFCODE('N','E','R')
#define MANUFACTURER_NES MANFCODE('N','E','S')
#define MANUFACTURER_NET MANFCODE('N','E','T')
#define MANUFACTURER_NGP MANFCODE('N','G','P')
#define MANUFACTURER_NIK MANFCODE('N','I','K')
#define MANUFACTURER_NIS MANFCODE('N','I','S')
#define MANUFACTURER_NJC MANFCODE('N','J','C')
#define MANUFACTURER_NKS MANFCODE('N','K','S')
#define MANUFACTURER_NLI MANFCODE('N','L','I')
#define MANUFACTURER_NME MANFCODE('N','M','E')
#define MANUFACTURER_NMG MANFCODE('N','M','G')
#define MANUFACTURER_NMS MANFCODE('N','M','S')
#define MANUFACTURER_NMT MANFCODE('N','M','T')
#define MANUFACTURER_NNT MANFCODE('N','N','T')
#define MANUFACTURER_NOQ MANFCODE('N','O','Q')
#define MANUFACTURER_NOV MANFCODE('N','O','V')
#define MANUFACTURER_NPS MANFCODE('N','P','S')
#define MANUFACTURER_NPT MANFCODE('N','P','T')
#define MANUFACTURER_NRM MANFCODE('N','R','M')
#define MANUFACTURER_NRN MANFCODE('N','R','N')
#define MANUFACTURER_NRT MANFCODE('N','R','T')
#define MANUFACTURER_NSE MANFCODE('N','S','E')
#define MANUFACTURER_NSP MANFCODE('N','S','P')
#define MANUFACTURER_NTC MANFCODE('N','T','C')
#define MANUFACTURER_NTM MANFCODE('N','T','M')
#define MANUFACTURER_NVD MANFCODE('N','V','D')
#define MANUFACTURER_NVN MANFCODE('N','V','N')
#define MANUFACTURER_NWG MANFCODE('N','W','G')
#define MANUFACTURER_NWM MANFCODE('N','W','M')
#define MANUFACTURER_NXG MANFCODE('N','X','G')
#define MANUFACTURER_NXP MANFCODE('N','X','P')
#define MANUFACTURER_NYG MANFCODE('N','Y','G')
#define MANUFACTURER_NYN MANFCODE('N','Y','N')
#define MANUFACTURER_NZR MANFCODE('N','Z','R')
#define MANUFACTURER_OAS MANFCODE('O','A','S')
#define MANUFACTURER_OBC MANFCODE('O','B','C')
#define MANUFACTURER_OBE MANFCODE('O','B','E')
#define MANUFACTURER_OBR MANFCODE('O','B','R')
#define MANUFACTURER_ODI MANFCODE('O','D','I')
#define MANUFACTURER_ODK MANFCODE('O','D','K')
#define MANUFACTURER_OEE MANFCODE('O','E','E')
#define MANUFACTURER_OLI MANFCODE('O','L','I')
#define MANUFACTURER_OMG MANFCODE('O','M','G')
#define MANUFACTURER_OMS MANFCODE('O','M','S')
#define MANUFACTURER_ONR MANFCODE('O','N','R')
#define MANUFACTURER_ONS MANFCODE('O','N','S')
#define MANUFACTURER_OPT MANFCODE('O','P','T')
#define MANUFACTURER_ORB MANFCODE('O','R','B')
#define MANUFACTURER_ORM MANFCODE('O','R','M')
#define MANUFACTURER_OSA MANFCODE('O','S','A')
#define MANUFACTURER_OSK MANFCODE('O','S','K')
#define MANUFACTURER_OTM MANFCODE('O','T','M')
#define MANUFACTURER_OYK MANFCODE('O','Y','K')
#define MANUFACTURER_OZK MANFCODE('O','Z','K')
#define MANUFACTURER_PAD MANFCODE('P','A','D')
#define MANUFACTURER_PAF MANFCODE('P','A','F')
#define MANUFACTURER_PAK MANFCODE('P','A','K')
#define MANUFACTURER_PAN MANFCODE('P','A','N')
#define MANUFACTURER_PBR MANFCODE('P','B','R')
#define MANUFACTURER_PCE MANFCODE('P','C','E')
#define MANUFACTURER_PCR MANFCODE('P','C','R')
#define MANUFACTURER_PDE MANFCODE('P','D','E')
#define MANUFACTURER_PDX MANFCODE('P','D','X')
#define MANUFACTURER_PEA MANFCODE('P','E','A')
#define MANUFACTURER_PEE MANFCODE('P','E','E')
#define MANUFACTURER_PEL MANFCODE('P','E','L')
#define MANUFACTURER_PEP MANFCODE('P','E','P')
#define MANUFACTURER_PER MANFCODE('P','E','R')
#define MANUFACTURER_PFI MANFCODE('P','F','I')
#define MANUFACTURER_PGE MANFCODE('P','G','E')
#define MANUFACTURER_PGP MANFCODE('P','G','P')
#define MANUFACTURER_PHL MANFCODE('P','H','L')
#define MANUFACTURER_PII MANFCODE('P','I','I')
#define MANUFACTURER_PIK MANFCODE('P','I','K')
#define MANUFACTURER_PIL MANFCODE('P','I','L')
#define MANUFACTURER_PIM MANFCODE('P','I','M')
#define MANUFACTURER_PIN MANFCODE('P','I','N')
#define MANUFACTURER_PIP MANFCODE('P','I','P')
#define MANUFACTURER_PIV MANFCODE('P','I','V')
#define MANUFACTURER_PLL MANFCODE('P','L','L')
#define MANUFACTURER_PLN MANFCODE('P','L','N')
#define MANUFACTURER_PLO MANFCODE('P','L','O')
#define MANUFACTURER_PLU MANFCODE('P','L','U')
#define MANUFACTURER_PME MANFCODE('P','M','E')
#define MANUFACTURER_PMG MANFCODE('P','M','G')
#define MANUFACTURER_PML MANFCODE('P','M','L')
#define MANUFACTURER_PMP MANFCODE('P','M','P')
#define MANUFACTURER_PMS MANFCODE('P','M','S')
#define MANUFACTURER_PMX MANFCODE('P','M','X')
#define MANUFACTURER_PNC MANFCODE('P','N','C')
#define MANUFACTURER_POD MANFCODE('P','O','D')
#define MANUFACTURER_POL MANFCODE('P','O','L')
#define MANUFACTURER_POW MANFCODE('P','O','W')
#define MANUFACTURER_POZ MANFCODE('P','O','Z')
#define MANUFACTURER_PPC MANFCODE('P','P','C')
#define MANUFACTURER_PPL MANFCODE('P','P','L')
#define MANUFACTURER_PPS MANFCODE('P','P','S')
#define MANUFACTURER_PQP MANFCODE('P','Q','P')
#define MANUFACTURER_PRA MANFCODE('P','R','A')
#define MANUFACTURER_PRE MANFCODE('P','R','E')
#define MANUFACTURER_PRG MANFCODE('P','R','G')
#define MANUFACTURER_PRI MANFCODE('P','R','I')
#define MANUFACTURER_PRM MANFCODE('P','R','M')
#define MANUFACTURER_PRO MANFCODE('P','R','O')
#define MANUFACTURER_PRY MANFCODE('P','R','Y')
#define MANUFACTURER_PSE MANFCODE('P','S','E')
#define MANUFACTURER_PSN MANFCODE('P','S','N')
#define MANUFACTURER_PST MANFCODE('P','S','T')
#define MANUFACTURER_PTI MANFCODE('P','T','I')
#define MANUFACTURER_PTR MANFCODE('P','T','R')
#define MANUFACTURER_PUK MANFCODE('P','U','K')
#define MANUFACTURER_PUL MANFCODE('P','U','L')
#define MANUFACTURER_PVT MANFCODE('P','V','T')
#define MANUFACTURER_PWB MANFCODE('P','W','B')
#define MANUFACTURER_PWR MANFCODE('P','W','R')
#define MANUFACTURER_PXC MANFCODE('P','X','C')
#define MANUFACTURER_PYU MANFCODE('P','Y','U')
#define MANUFACTURER_QDR MANFCODE('Q','D','R')
#define MANUFACTURER_QDS MANFCODE('Q','D','S')
#define MANUFACTURER_QFP MANFCODE('Q','F','P')
#define MANUFACTURER_QSD MANFCODE('Q','S','D')
#define MANUFACTURER_QTS MANFCODE('Q','T','S')
#define MANUFACTURER_RAC MANFCODE('R','A','C')
#define MANUFACTURER_RAD MANFCODE('R','A','D')
#define MANUFACTURER_RAM MANFCODE('R','A','M')
#define MANUFACTURER_RAS MANFCODE('R','A','S')
#define MANUFACTURER_RAY MANFCODE('R','A','Y')
#define MANUFACTURER_RBM MANFCODE('R','B','M')
#define MANUFACTURER_RCE MANFCODE('R','C','E')
#define MANUFACTURER_RDK MANFCODE('R','D','K')
#define MANUFACTURER_RDM MANFCODE('R','D','M')
#define MANUFACTURER_REC MANFCODE('R','E','C')
#define MANUFACTURER_REF MANFCODE('R','E','F')
#define MANUFACTURER_REI MANFCODE('R','E','I')
#define MANUFACTURER_REL MANFCODE('R','E','L')
#define MANUFACTURER_REM MANFCODE('R','E','M')
#define MANUFACTURER_REP MANFCODE('R','E','P')
#define MANUFACTURER_RES MANFCODE('R','E','S')
#define MANUFACTURER_RIC MANFCODE('R','I','C')
#define MANUFACTURER_RIL MANFCODE('R','I','L')
#define MANUFACTURER_RIM MANFCODE('R','I','M')
#define MANUFACTURER_RIN MANFCODE('R','I','N')
#define MANUFACTURER_RIT MANFCODE('R','I','T')
#define MANUFACTURER_RIX MANFCODE('R','I','X')
#define MANUFACTURER_RIZ MANFCODE('R','I','Z')
#define MANUFACTURER_RKE MANFCODE('R','K','E')
#define MANUFACTURER_RMA MANFCODE('R','M','A')
#define MANUFACTURER_RMG MANFCODE('R','M','G')
#define MANUFACTURER_RML MANFCODE('R','M','L')
#define MANUFACTURER_RMR MANFCODE('R','M','R')
#define MANUFACTURER_RMT MANFCODE('R','M','T')
#define MANUFACTURER_RNW MANFCODE('R','N','W')
#define MANUFACTURER_ROK MANFCODE('R','O','K')
#define MANUFACTURER_RSA MANFCODE('R','S','A')
#define MANUFACTURER_RSM MANFCODE('R','S','M')
#define MANUFACTURER_RSW MANFCODE('R','S','W')
#define MANUFACTURER_SAA MANFCODE('S','A','A')
#define MANUFACTURER_SAC MANFCODE('S','A','C')
#define MANUFACTURER_SAE MANFCODE('S','A','E')
#define MANUFACTURER_SAG MANFCODE('S','A','G')
#define MANUFACTURER_SAM MANFCODE('S','A','M')
#define MANUFACTURER_SAN MANFCODE('S','A','N')
#define MANUFACTURER_SAP MANFCODE('S','A','P')
#define MANUFACTURER_SAT MANFCODE('S','A','T')
#define MANUFACTURER_SBC MANFCODE('S','B','C')
#define MANUFACTURER_SCA MANFCODE('S','C','A')
#define MANUFACTURER_SCE MANFCODE('S','C','E')
#define MANUFACTURER_SCH MANFCODE('S','C','H')
#define MANUFACTURER_SCL MANFCODE('S','C','L')
#define MANUFACTURER_SCM MANFCODE('S','C','M')
#define MANUFACTURER_SCR MANFCODE('S','C','R')
#define MANUFACTURER_SCT MANFCODE('S','C','T')
#define MANUFACTURER_SCW MANFCODE('S','C','W')
#define MANUFACTURER_SDC MANFCODE('S','D','C')
#define MANUFACTURER_SDM MANFCODE('S','D','M')
#define MANUFACTURER_SDS MANFCODE('S','D','S')
#define MANUFACTURER_SEC MANFCODE('S','E','C')
#define MANUFACTURER_SEE MANFCODE('S','E','E')
#define MANUFACTURER_SEH MANFCODE('S','E','H')
#define MANUFACTURER_SEI MANFCODE('S','E','I')
#define MANUFACTURER_SEK MANFCODE('S','E','K')
#define MANUFACTURER_SEL MANFCODE('S','E','L')
#define MANUFACTURER_SEM MANFCODE('S','E','M')
#define MANUFACTURER_SEN MANFCODE('S','E','N')
#define MANUFACTURER_SEO MANFCODE('S','E','O')
#define MANUFACTURER_SET MANFCODE('S','E','T')
#define MANUFACTURER_SFI MANFCODE('S','F','I')
#define MANUFACTURER_SFT MANFCODE('S','F','T')
#define MANUFACTURER_SGA MANFCODE('S','G','A')
#define MANUFACTURER_SGM MANFCODE('S','G','M')
#define MANUFACTURER_SGN MANFCODE('S','G','N')
#define MANUFACTURER_SGX MANFCODE('S','G','X')
#define MANUFACTURER_SHD MANFCODE('S','H','D')
#define MANUFACTURER_SHE MANFCODE('S','H','E')
#define MANUFACTURER_SHM MANFCODE('S','H','M')
#define MANUFACTURER_SHT MANFCODE('S','H','T')
#define MANUFACTURER_SIC MANFCODE('S','I','C')
#define MANUFACTURER_SIE MANFCODE('S','I','E')
#define MANUFACTURER_SIG MANFCODE('S','I','G')
#define MANUFACTURER_SIJ MANFCODE('S','I','J')
#define MANUFACTURER_SIL MANFCODE('S','I','L')
#define MANUFACTURER_SIM MANFCODE('S','I','M')
#define MANUFACTURER_SIN MANFCODE('S','I','N')
#define MANUFACTURER_SIS MANFCODE('S','I','S')
#define MANUFACTURER_SIT MANFCODE('S','I','T')
#define MANUFACTURER_SIV MANFCODE('S','I','V')
#define MANUFACTURER_SIX MANFCODE('S','I','X')
#define MANUFACTURER_SKI MANFCODE('S','K','I')
#define MANUFACTURER_SKK MANFCODE('S','K','K')
#define MANUFACTURER_SKN MANFCODE('S','K','N')
#define MANUFACTURER_SKQ MANFCODE('S','K','Q')
#define MANUFACTURER_SKT MANFCODE('S','K','T')
#define MANUFACTURER_SKY MANFCODE('S','K','Y')
#define MANUFACTURER_SLB MANFCODE('S','L','B')
#define MANUFACTURER_SLG MANFCODE('S','L','G')
#define MANUFACTURER_SLP MANFCODE('S','L','P')
#define MANUFACTURER_SLV MANFCODE('S','L','V')
#define MANUFACTURER_SLW MANFCODE('S','L','W')
#define MANUFACTURER_SLX MANFCODE('S','L','X')
#define MANUFACTURER_SMA MANFCODE('S','M','A')
#define MANUFACTURER_SMC MANFCODE('S','M','C')
#define MANUFACTURER_SME MANFCODE('S','M','E')
#define MANUFACTURER_SMG MANFCODE('S','M','G')
#define MANUFACTURER_SMI MANFCODE('S','M','I')
#define MANUFACTURER_SML MANFCODE('S','M','L')
#define MANUFACTURER_SMM MANFCODE('S','M','M')
#define MANUFACTURER_SMN MANFCODE('S','M','N')
#define MANUFACTURER_SMP MANFCODE('S','M','P')
#define MANUFACTURER_SMQ MANFCODE('S','M','Q')
#define MANUFACTURER_SMR MANFCODE('S','M','R')
#define MANUFACTURER_SMS MANFCODE('S','M','S')
#define MANUFACTURER_SMT MANFCODE('S','M','T')
#define MANUFACTURER_SMX MANFCODE('S','M','X')
#define MANUFACTURER_SNB MANFCODE('S','N','B')
#define MANUFACTURER_SNM MANFCODE('S','N','M')
#define MANUFACTURER_SNR MANFCODE('S','N','R')
#define MANUFACTURER_SNS MANFCODE('S','N','S')
#define MANUFACTURER_SNT MANFCODE('S','N','T')
#define MANUFACTURER_SOC MANFCODE('S','O','C')
#define MANUFACTURER_SOF MANFCODE('S','O','F')
#define MANUFACTURER_SOG MANFCODE('S','O','G')
#define MANUFACTURER_SOL MANFCODE('S','O','L')
#define MANUFACTURER_SOM MANFCODE('S','O','M')
#define MANUFACTURER_SON MANFCODE('S','O','N')
#define MANUFACTURER_SOS MANFCODE('S','O','S')
#define MANUFACTURER_SOT MANFCODE('S','O','T')
#define MANUFACTURER_SPC MANFCODE('S','P','C')
#define MANUFACTURER_SPE MANFCODE('S','P','E')
#define MANUFACTURER_SPL MANFCODE('S','P','L')
#define MANUFACTURER_SPM MANFCODE('S','P','M')
#define MANUFACTURER_SPX MANFCODE('S','P','X')
#define MANUFACTURER_SPZ MANFCODE('S','P','Z')
#define MANUFACTURER_SRE MANFCODE('S','R','E')
#define MANUFACTURER_SRF MANFCODE('S','R','F')
#define MANUFACTURER_SRN MANFCODE('S','R','N')
#define MANUFACTURER_SRV MANFCODE('S','R','V')
#define MANUFACTURER_SSE MANFCODE('S','S','E')
#define MANUFACTURER_SSG MANFCODE('S','S','G')
#define MANUFACTURER_SSI MANFCODE('S','S','I')
#define MANUFACTURER_SSL MANFCODE('S','S','L')
#define MANUFACTURER_SSM MANFCODE('S','S','M')
#define MANUFACTURER_SSN MANFCODE('S','S','N')
#define MANUFACTURER_SSS MANFCODE('S','S','S')
#define MANUFACTURER_SST MANFCODE('S','S','T')
#define MANUFACTURER_STA MANFCODE('S','T','A')
#define MANUFACTURER_STC MANFCODE('S','T','C')
#define MANUFACTURER_STD MANFCODE('S','T','D')
#define MANUFACTURER_STE MANFCODE('S','T','E')
#define MANUFACTURER_STF MANFCODE('S','T','F')
#define MANUFACTURER_STL MANFCODE('S','T','L')
#define MANUFACTURER_STM MANFCODE('S','T','M')
#define MANUFACTURER_STO MANFCODE('S','T','O')
#define MANUFACTURER_STR MANFCODE('S','T','R')
#define MANUFACTURER_STS MANFCODE('S','T','S')
#define MANUFACTURER_STV MANFCODE('S','T','V')
#define MANUFACTURER_STZ MANFCODE('S','T','Z')
#define MANUFACTURER_SUN MANFCODE('S','U','N')
#define MANUFACTURER_SVM MANFCODE('S','V','M')
#define MANUFACTURER_SVT MANFCODE('S','V','T')
#define MANUFACTURER_SWI MANFCODE('S','W','I')
#define MANUFACTURER_SWM MANFCODE('S','W','M')
#define MANUFACTURER_SWS MANFCODE('S','W','S')
#define MANUFACTURER_SWT MANFCODE('S','W','T')
#define MANUFACTURER_SYC MANFCODE('S','Y','C')
#define MANUFACTURER_SYN MANFCODE('S','Y','N')
#define MANUFACTURER_SYS MANFCODE('S','Y','S')
#define MANUFACTURER_SYX MANFCODE('S','Y','X')
#define MANUFACTURER_SZS MANFCODE('S','Z','S')
#define MANUFACTURER_TAG MANFCODE('T','A','G')
#define MANUFACTURER_TAL MANFCODE('T','A','L')
#define MANUFACTURER_TAN MANFCODE('T','A','N')
#define MANUFACTURER_TAS MANFCODE('T','A','S')
#define MANUFACTURER_TAT MANFCODE('T','A','T')
#define MANUFACTURER_TAY MANFCODE('T','A','Y')
#define MANUFACTURER_TAZ MANFCODE('T','A','Z')
#define MANUFACTURER_TBN MANFCODE('T','B','N')
#define MANUFACTURER_TBS MANFCODE('T','B','S')
#define MANUFACTURER_TCE MANFCODE('T','C','E')
#define MANUFACTURER_TCH MANFCODE('T','C','H')
#define MANUFACTURER_TCM MANFCODE('T','C','M')
#define MANUFACTURER_TCO MANFCODE('T','C','O')
#define MANUFACTURER_TCP MANFCODE('T','C','P')
#define MANUFACTURER_TCT MANFCODE('T','C','T')
#define MANUFACTURER_TCX MANFCODE('T','C','X')
#define MANUFACTURER_TCZ MANFCODE('T','C','Z')
#define MANUFACTURER_TDC MANFCODE('T','D','C')
#define MANUFACTURER_TEA MANFCODE('T','E','A')
#define MANUFACTURER_TEC MANFCODE('T','E','C')
#define MANUFACTURER_TEH MANFCODE('T','E','H')
#define MANUFACTURER_TEI MANFCODE('T','E','I')
#define MANUFACTURER_TEK MANFCODE('T','E','K')
#define MANUFACTURER_TEN MANFCODE('T','E','N')
#define MANUFACTURER_TEO MANFCODE('T','E','O')
#define MANUFACTURER_TEP MANFCODE('T','E','P')
#define MANUFACTURER_TEU MANFCODE('T','E','U')
#define MANUFACTURER_TFC MANFCODE('T','F','C')
#define MANUFACTURER_TFG MANFCODE('T','F','G')
#define MANUFACTURER_TGX MANFCODE('T','G','X')
#define MANUFACTURER_THE MANFCODE('T','H','E')
#define MANUFACTURER_THW MANFCODE('T','H','W')
#define MANUFACTURER_TIC MANFCODE('T','I','C')
#define MANUFACTURER_TID MANFCODE('T','I','D')
#define MANUFACTURER_TIG MANFCODE('T','I','G')
#define MANUFACTURER_TII MANFCODE('T','I','I')
#define MANUFACTURER_TIL MANFCODE('T','I','L')
#define MANUFACTURER_TIP MANFCODE('T','I','P')
#define MANUFACTURER_TIS MANFCODE('T','I','S')
#define MANUFACTURER_TIX MANFCODE('T','I','X')
#define MANUFACTURER_TKN MANFCODE('T','K','N')
#define MANUFACTURER_TKS MANFCODE('T','K','S')
#define MANUFACTURER_TLC MANFCODE('T','L','C')
#define MANUFACTURER_TLM MANFCODE('T','L','M')
#define MANUFACTURER_TLR MANFCODE('T','L','R')
#define MANUFACTURER_TLS MANFCODE('T','L','S')
#define MANUFACTURER_TLT MANFCODE('T','L','T')
#define MANUFACTURER_TLY MANFCODE('T','L','Y')
#define MANUFACTURER_TME MANFCODE('T','M','E')
#define MANUFACTURER_TMK MANFCODE('T','M','K')
#define MANUFACTURER_TMS MANFCODE('T','M','S')
#define MANUFACTURER_TMZ MANFCODE('T','M','Z')
#define MANUFACTURER_TOP MANFCODE('T','O','P')
#define MANUFACTURER_TPB MANFCODE('T','P','B')
#define MANUFACTURER_TPC MANFCODE('T','P','C')
#define MANUFACTURER_TPI MANFCODE('T','P','I')
#define MANUFACTURER_TPJ MANFCODE('T','P','J')
#define MANUFACTURER_TPL MANFCODE('T','P','L')
#define MANUFACTURER_TPZ MANFCODE('T','P','Z')
#define MANUFACTURER_TRC MANFCODE('T','R','C')
#define MANUFACTURER_TRG MANFCODE('T','R','G')
#define MANUFACTURER_TRI MANFCODE('T','R','I')
#define MANUFACTURER_TRJ MANFCODE('T','R','J')
#define MANUFACTURER_TRL MANFCODE('T','R','L')
#define MANUFACTURER_TRN MANFCODE('T','R','N')
#define MANUFACTURER_TRO MANFCODE('T','R','O')
#define MANUFACTURER_TRU MANFCODE('T','R','U')
#define MANUFACTURER_TRV MANFCODE('T','R','V')
#define MANUFACTURER_TRW MANFCODE('T','R','W')
#define MANUFACTURER_TRX MANFCODE('T','R','X')
#define MANUFACTURER_TRZ MANFCODE('T','R','Z')
#define MANUFACTURER_TSD MANFCODE('T','S','D')
#define MANUFACTURER_TSE MANFCODE('T','S','E')
#define MANUFACTURER_TSG MANFCODE('T','S','G')
#define MANUFACTURER_TTM MANFCODE('T','T','M')
#define MANUFACTURER_TTR MANFCODE('T','T','R')
#define MANUFACTURER_TTT MANFCODE('T','T','T')
#define MANUFACTURER_TUR MANFCODE('T','U','R')
#define MANUFACTURER_TWO MANFCODE('T','W','O')
#define MANUFACTURER_TXL MANFCODE('T','X','L')
#define MANUFACTURER_UAG MANFCODE('U','A','G')
#define MANUFACTURER_UBI MANFCODE('U','B','I')
#define MANUFACTURER_UBY MANFCODE('U','B','Y')
#define MANUFACTURER_UEI MANFCODE('U','E','I')
#define MANUFACTURER_UEL MANFCODE('U','E','L')
#define MANUFACTURER_UGI MANFCODE('U','G','I')
#define MANUFACTURER_UGT MANFCODE('U','G','T')
#define MANUFACTURER_UHM MANFCODE('U','H','M')
#define MANUFACTURER_UNE MANFCODE('U','N','E')
#define MANUFACTURER_UNI MANFCODE('U','N','I')
#define MANUFACTURER_URM MANFCODE('U','R','M')
#define MANUFACTURER_USC MANFCODE('U','S','C')
#define MANUFACTURER_UTF MANFCODE('U','T','F')
#define MANUFACTURER_UTI MANFCODE('U','T','I')
#define MANUFACTURER_UTL MANFCODE('U','T','L')
#define MANUFACTURER_UTT MANFCODE('U','T','T')
#define MANUFACTURER_VAL MANFCODE('V','A','L')
#define MANUFACTURER_VDP MANFCODE('V','D','P')
#define MANUFACTURER_VEC MANFCODE('V','E','C')
#define MANUFACTURER_VEL MANFCODE('V','E','L')
#define MANUFACTURER_VER MANFCODE('V','E','R')
#define MANUFACTURER_VES MANFCODE('V','E','S')
#define MANUFACTURER_VGO MANFCODE('V','G','O')
#define MANUFACTURER_VIE MANFCODE('V','I','E')
#define MANUFACTURER_VIK MANFCODE('V','I','K')
#define MANUFACTURER_VIM MANFCODE('V','I','M')
#define MANUFACTURER_VIN MANFCODE('V','I','N')
#define MANUFACTURER_VIP MANFCODE('V','I','P')
#define MANUFACTURER_VIT MANFCODE('V','I','T')
#define MANUFACTURER_VLT MANFCODE('V','L','T')
#define MANUFACTURER_VMP MANFCODE('V','M','P')
#define MANUFACTURER_VNE MANFCODE('V','N','E')
#define MANUFACTURER_VPI MANFCODE('V','P','I')
#define MANUFACTURER_VPL MANFCODE('V','P','L')
#define MANUFACTURER_VSE MANFCODE('V','S','E')
#define MANUFACTURER_VSN MANFCODE('V','S','N')
#define MANUFACTURER_VTC MANFCODE('V','T','C')
#define MANUFACTURER_VTG MANFCODE('V','T','G')
#define MANUFACTURER_VTK MANFCODE('V','T','K')
#define MANUFACTURER_VTN MANFCODE('V','T','N')
#define MANUFACTURER_VTZ MANFCODE('V','T','Z')
#define MANUFACTURER_VVV MANFCODE('V','V','V')
#define MANUFACTURER_WAD MANFCODE('W','A','D')
#define MANUFACTURER_WAH MANFCODE('W','A','H')
#define MANUFACTURER_WAI MANFCODE('W','A','I')
#define MANUFACTURER_WAL MANFCODE('W','A','L')
#define MANUFACTURER_WDN MANFCODE('W','D','N')
#define MANUFACTURER_WEB MANFCODE('W','E','B')
#define MANUFACTURER_WEG MANFCODE('W','E','G')
#define MANUFACTURER_WEH MANFCODE('W','E','H')
#define MANUFACTURER_WEL MANFCODE('W','E','L')
#define MANUFACTURER_WEP MANFCODE('W','E','P')
#define MANUFACTURER_WFT MANFCODE('W','F','T')
#define MANUFACTURER_WGN MANFCODE('W','G','N')
#define MANUFACTURER_WGP MANFCODE('W','G','P')
#define MANUFACTURER_WIG MANFCODE('W','I','G')
#define MANUFACTURER_WIK MANFCODE('W','I','K')
#define MANUFACTURER_WIN MANFCODE('W','I','N')
#define MANUFACTURER_WKL MANFCODE('W','K','L')
#define MANUFACTURER_WKX MANFCODE('W','K','X')
#define MANUFACTURER_WMO MANFCODE('W','M','O')
#define MANUFACTURER_WNC MANFCODE('W','N','C')
#define MANUFACTURER_WNW MANFCODE('W','N','W')
#define MANUFACTURER_WOW MANFCODE('W','O','W')
#define MANUFACTURER_WSD MANFCODE('W','S','D')
#define MANUFACTURER_WSE MANFCODE('W','S','E')
#define MANUFACTURER_WSG MANFCODE('W','S','G')
#define MANUFACTURER_WSM MANFCODE('W','S','M')
#define MANUFACTURER_WSR MANFCODE('W','S','R')
#define MANUFACTURER_WTI MANFCODE('W','T','I')
#define MANUFACTURER_WTL MANFCODE('W','T','L')
#define MANUFACTURER_WTM MANFCODE('W','T','M')
#define MANUFACTURER_WTT MANFCODE('W','T','T')
#define MANUFACTURER_WUR MANFCODE('W','U','R')
#define MANUFACTURER_WZG MANFCODE('W','Z','G')
#define MANUFACTURER_WZT MANFCODE('W','Z','T')
#define MANUFACTURER_XAO MANFCODE('X','A','O')
#define MANUFACTURER_XEM MANFCODE('X','E','M')
#define MANUFACTURER_XIO MANFCODE('X','I','O')
#define MANUFACTURER_XJM MANFCODE('X','J','M')
#define MANUFACTURER_XMA MANFCODE('X','M','A')
#define MANUFACTURER_XMX MANFCODE('X','M','X')
#define MANUFACTURER_XTM MANFCODE('X','T','M')
#define MANUFACTURER_XTR MANFCODE('X','T','R')
#define MANUFACTURER_XTY MANFCODE('X','T','Y')
#define MANUFACTURER_YDD MANFCODE('Y','D','D')
#define MANUFACTURER_YDS MANFCODE('Y','D','S')
#define MANUFACTURER_YFC MANFCODE('Y','F','C')
#define MANUFACTURER_YGM MANFCODE('Y','G','M')
#define MANUFACTURER_YHE MANFCODE('Y','H','E')
#define MANUFACTURER_YJZ MANFCODE('Y','J','Z')
#define MANUFACTURER_YNP MANFCODE('Y','N','P')
#define MANUFACTURER_YPP MANFCODE('Y','P','P')
#define MANUFACTURER_YSS MANFCODE('Y','S','S')
#define MANUFACTURER_YTE MANFCODE('Y','T','E')
#define MANUFACTURER_YTL MANFCODE('Y','T','L')
#define MANUFACTURER_YYW MANFCODE('Y','Y','W')
#define MANUFACTURER_YZR MANFCODE('Y','Z','R')
#define MANUFACTURER_ZAG MANFCODE('Z','A','G')
#define MANUFACTURER_ZAP MANFCODE('Z','A','P')
#define MANUFACTURER_ZAR MANFCODE('Z','A','R')
#define MANUFACTURER_ZCH MANFCODE('Z','C','H')
#define MANUFACTURER_ZEL MANFCODE('Z','E','L')
#define MANUFACTURER_ZEN MANFCODE('Z','E','N')
#define MANUFACTURER_ZEX MANFCODE('Z','E','X')
#define MANUFACTURER_ZFY MANFCODE('Z','F','Y')
#define MANUFACTURER_ZGX MANFCODE('Z','G','X')
#define MANUFACTURER_ZIP MANFCODE('Z','I','P')
#define MANUFACTURER_ZIV MANFCODE('Z','I','V')
#define MANUFACTURER_ZJY MANFCODE('Z','J','Y')
#define MANUFACTURER_ZOT MANFCODE('Z','O','T')
#define MANUFACTURER_ZPA MANFCODE('Z','P','A')
#define MANUFACTURER_ZRI MANFCODE('Z','R','I')
#define MANUFACTURER_ZRM MANFCODE('Z','R','M')
#define MANUFACTURER_ZTE MANFCODE('Z','T','E')
#define MANUFACTURER_ZTX MANFCODE('Z','T','X')
#define MANUFACTURER_ZTY MANFCODE('Z','T','Y')
#define MANUFACTURER_ZVC MANFCODE('Z','V','C')
#define MANUFACTURER_ZXT MANFCODE('Z','X','T')
#define MANUFACTURER_ZXY MANFCODE('Z','X','Y')
#define MANUFACTURER_ZYB MANFCODE('Z','Y','B')
#define MANUFACTURER_ZZZ MANFCODE('Z','Z','Z')

#endif
