/*
 * fhist - file history and comparison tools
 * Copyright (C) 2012 Peter Miller
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or (at
 * your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include <common/ac/stdlib.h>
#include <libexplain/strdup.h>

#include <common/expand.h>


/*
 * Expand a global variable name.
 * Returns original argument if string is not a global variable,
 * or returns copied value of global variable.
 */

char *
expand(const char *cp)
{
    char            *var;       /* variable value */

    if (!cp)
        return explain_strdup_or_die("");
    if (*cp != '.')
        return explain_strdup_or_die(cp);
    var = getenv(cp);
    if (!var || !*var)
        var = getenv(cp + 1);
    if (!var || !*var)
    {
        if (!cp)
            return explain_strdup_or_die("");
        return explain_strdup_or_die(cp);
    }
    return explain_strdup_or_die(var);
}


/* vim: set ts=8 sw=4 et : */
